/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetPropertyDelegate;
import org.jetbrains.jet.lang.psi.JetWithExpressionInitializer;
import org.jetbrains.jet.plugin.JetLanguage;

public abstract class JetStubElementType<StubT extends StubElement, PsiT extends PsiElement>
extends IStubElementType<StubT, PsiT> {
    public JetStubElementType(@NotNull @NonNls String debugName) {
        super(debugName, JetLanguage.INSTANCE);
    }

    public abstract PsiT createPsiFromAst(@NotNull ASTNode var1);

    @Override
    public String getExternalId() {
        return "jet." + this.toString();
    }

    @Override
    public boolean shouldCreateStub(ASTNode node) {
        JetExpression delegateExpression;
        JetExpression initializer;
        PsiElement psi = node.getPsi();
        if (PsiTreeUtil.getParentOfType(psi, JetFunctionLiteral.class) != null) {
            return false;
        }
        JetBlockExpression blockExpression = PsiTreeUtil.getParentOfType(psi, JetBlockExpression.class);
        if (blockExpression != null) {
            return false;
        }
        JetWithExpressionInitializer withInitializer = PsiTreeUtil.getParentOfType(psi, JetWithExpressionInitializer.class, true, JetBlockExpression.class);
        if (withInitializer != null && PsiTreeUtil.isAncestor(initializer = withInitializer.getInitializer(), psi, true)) {
            return false;
        }
        JetPropertyDelegate delegate = PsiTreeUtil.getParentOfType(psi, JetPropertyDelegate.class, true, JetBlockExpression.class);
        if (delegate != null && PsiTreeUtil.isAncestor(delegateExpression = delegate.getExpression(), psi, true)) {
            return false;
        }
        return super.shouldCreateStub(node);
    }
}

