/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetExpressionImpl;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lexer.JetTokens;

public class JetWhenExpression
extends JetExpressionImpl {
    public JetWhenExpression(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public List<JetWhenEntry> getEntries() {
        return this.findChildrenByType(JetNodeTypes.WHEN_ENTRY);
    }

    @Nullable
    public JetExpression getSubjectExpression() {
        return this.findChildByClass(JetExpression.class);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitWhenExpression(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitWhenExpression(this, data);
    }

    @NotNull
    public PsiElement getWhenKeywordElement() {
        return this.findChildByType(JetTokens.WHEN_KEYWORD);
    }

    @Nullable
    public PsiElement getCloseBraceNode() {
        ASTNode openBraceNode = this.getNode().findChildByType(JetTokens.RBRACE);
        return openBraceNode != null ? openBraceNode.getPsi() : null;
    }

    @Nullable
    public JetExpression getElseExpression() {
        for (JetWhenEntry entry : this.getEntries()) {
            if (!entry.isElse()) continue;
            return entry.getExpression();
        }
        return null;
    }
}

