/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.IfNotParsed;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lexer.JetTokens;

public class JetUserType
extends JetTypeElement {
    public JetUserType(@NotNull ASTNode node) {
        super(node);
    }

    public boolean isAbsoluteInRootNamespace() {
        return this.findChildByType(JetTokens.PACKAGE_KEYWORD) != null;
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitUserType(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitUserType(this, data);
    }

    public JetTypeArgumentList getTypeArgumentList() {
        return (JetTypeArgumentList)this.findChildByType(JetNodeTypes.TYPE_ARGUMENT_LIST);
    }

    @NotNull
    public List<JetTypeProjection> getTypeArguments() {
        JetTypeArgumentList typeArgumentList = this.getTypeArgumentList();
        return typeArgumentList == null ? Collections.emptyList() : typeArgumentList.getArguments();
    }

    @Override
    @NotNull
    public List<JetTypeReference> getTypeArgumentsAsTypes() {
        ArrayList<JetTypeReference> result = Lists.newArrayList();
        for (JetTypeProjection projection : this.getTypeArguments()) {
            result.add(projection.getTypeReference());
        }
        return result;
    }

    @IfNotParsed
    @Nullable
    public JetSimpleNameExpression getReferenceExpression() {
        return (JetSimpleNameExpression)this.findChildByType(JetNodeTypes.REFERENCE_EXPRESSION);
    }

    @Nullable
    public JetUserType getQualifier() {
        return (JetUserType)this.findChildByType(JetNodeTypes.USER_TYPE);
    }

    @Nullable
    public String getReferencedName() {
        JetSimpleNameExpression referenceExpression = this.getReferenceExpression();
        return referenceExpression == null ? null : referenceExpression.getReferencedName();
    }
}

