/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class JetNamespaceHeader
extends JetReferenceExpression {
    private String qualifiedNameCache = null;

    public JetNamespaceHeader(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public List<JetSimpleNameExpression> getParentNamespaceNames() {
        List<JetSimpleNameExpression> parentParts = this.findChildrenByType(JetNodeTypes.REFERENCE_EXPRESSION);
        JetSimpleNameExpression lastPart = (JetSimpleNameExpression)this.findLastChildByType(JetNodeTypes.REFERENCE_EXPRESSION);
        parentParts.remove(lastPart);
        return parentParts;
    }

    @Nullable
    public JetSimpleNameExpression getLastPartExpression() {
        return (JetSimpleNameExpression)this.findLastChildByType(JetNodeTypes.REFERENCE_EXPRESSION);
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        return ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, PsiReferenceService.Hints.NO_HINTS);
    }

    @Override
    @Nullable
    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        return references.length == 1 ? references[0] : null;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        JetSimpleNameExpression lastPart = (JetSimpleNameExpression)this.findLastChildByType(JetNodeTypes.REFERENCE_EXPRESSION);
        if (lastPart == null) {
            return null;
        }
        return lastPart.getIdentifier();
    }

    @Override
    @NotNull
    public String getName() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        return nameIdentifier == null ? "" : nameIdentifier.getText();
    }

    @NotNull
    public Name getNameAsName() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        return nameIdentifier == null ? JetPsiUtil.ROOT_NAMESPACE_NAME : Name.identifier(nameIdentifier.getText());
    }

    public boolean isRoot() {
        return this.getName().length() == 0;
    }

    @NotNull
    public FqName getFqName() {
        String qualifiedName = this.getQualifiedName();
        return qualifiedName.isEmpty() ? FqName.ROOT : new FqName(qualifiedName);
    }

    @NotNull
    public FqName getParentFqName(JetReferenceExpression nameExpression) {
        String parentQualifiedName = this.getQualifiedNameParentOf(nameExpression);
        return parentQualifiedName.isEmpty() ? FqName.ROOT : new FqName(parentQualifiedName);
    }

    @NotNull
    public String getQualifiedName() {
        if (this.qualifiedNameCache == null) {
            this.qualifiedNameCache = this.getQualifiedNameParentOf(null);
        }
        return this.qualifiedNameCache;
    }

    @NotNull
    private String getQualifiedNameParentOf(@Nullable JetReferenceExpression nameExpression) {
        StringBuilder builder = new StringBuilder();
        for (JetSimpleNameExpression e : this.findChildrenByClass(JetSimpleNameExpression.class)) {
            if (e == nameExpression) break;
            if (builder.length() > 0) {
                builder.append(".");
            }
            builder.append(e.getReferencedName());
        }
        return builder.toString();
    }

    @Override
    public void subtreeChanged() {
        this.qualifiedNameCache = null;
    }
}

