/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.resolve.ImportPath;

public class JetImportsFactory {
    @NotNull
    private Project project;
    private final Map<ImportPath, JetImportDirective> importsCache = Maps.newHashMap();

    public void setProject(@NotNull Project project) {
        this.importsCache.clear();
        this.project = project;
    }

    @NotNull
    public JetImportDirective createImportDirective(@NotNull ImportPath importPath) {
        JetImportDirective directive = this.importsCache.get(importPath);
        if (directive != null) {
            return directive;
        }
        JetImportDirective createdDirective = JetPsiFactory.createImportDirective(this.project, importPath);
        this.importsCache.put(importPath, createdDirective);
        return createdDirective;
    }

    @NotNull
    public Collection<JetImportDirective> createImportDirectives(@NotNull Collection<ImportPath> importPaths) {
        return Collections2.transform(importPaths, new Function<ImportPath, JetImportDirective>(){

            @Override
            public JetImportDirective apply(@Nullable ImportPath path) {
                assert (path != null);
                return JetImportsFactory.this.createImportDirective(path);
            }
        });
    }
}

