/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.IfNotParsed;
import org.jetbrains.jet.lang.psi.JetElementImpl;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lexer.JetTokens;

public class JetImportDirective
extends JetElementImpl {
    public JetImportDirective(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitImportDirective(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitImportDirective(this, data);
    }

    public boolean isAbsoluteInRootNamespace() {
        return this.findChildByType(JetTokens.PACKAGE_KEYWORD) != null;
    }

    @IfNotParsed
    @Nullable
    public JetExpression getImportedReference() {
        return this.findChildByClass(JetExpression.class);
    }

    @Nullable
    public ASTNode getAliasNameNode() {
        boolean asPassed = false;
        for (ASTNode childNode = this.getNode().getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            IElementType tt = childNode.getElementType();
            if (tt == JetTokens.AS_KEYWORD) {
                asPassed = true;
            }
            if (!asPassed || tt != JetTokens.IDENTIFIER) continue;
            return childNode;
        }
        return null;
    }

    @Nullable
    public String getAliasName() {
        ASTNode aliasNameNode = this.getAliasNameNode();
        if (aliasNameNode == null) {
            return null;
        }
        return aliasNameNode.getText();
    }

    public boolean isAllUnder() {
        return this.getNode().findChildByType(JetTokens.MUL) != null;
    }
}

