/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics.rendering;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.diagnostics.rendering.Renderer;
import org.jetbrains.jet.lang.diagnostics.rendering.Renderers;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.renderer.DescriptorRenderer;

public class TabledDescriptorRenderer {
    protected final List<TableOrTextRenderer> renderers = Lists.newArrayList();

    public TabledDescriptorRenderer text(@NotNull TextRenderer textRenderer) {
        this.renderers.add(textRenderer);
        return this;
    }

    public TabledDescriptorRenderer table(@NotNull TableRenderer tableRenderer) {
        this.renderers.add(tableRenderer);
        return this;
    }

    public static TextRenderer newText() {
        return new TextRenderer();
    }

    public static TableRenderer newTable() {
        return new TableRenderer();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (TableOrTextRenderer tableOrTextRenderer : this.renderers) {
            if (tableOrTextRenderer instanceof TableRenderer) {
                this.renderTable((TableRenderer)tableOrTextRenderer, result);
                continue;
            }
            this.renderText((TextRenderer)tableOrTextRenderer, result);
        }
        return result.toString();
    }

    @NotNull
    public Renderer<JetType> getTypeRenderer() {
        return Renderers.RENDER_TYPE;
    }

    protected void renderText(TextRenderer textRenderer, StringBuilder result) {
        for (TextRenderer.TextElement element : textRenderer.elements) {
            result.append(element.text);
        }
    }

    protected void renderTable(TableRenderer table, StringBuilder result) {
        if (table.rows.isEmpty()) {
            return;
        }
        for (TableRenderer.TableRow row : table.rows) {
            if (row instanceof TextRenderer) {
                this.renderText((TextRenderer)row, result);
            }
            if (row instanceof TableRenderer.DescriptorRow) {
                result.append(DescriptorRenderer.COMPACT.render(((TableRenderer.DescriptorRow)row).descriptor));
            }
            if (row instanceof TableRenderer.FunctionArgumentsRow) {
                TableRenderer.FunctionArgumentsRow functionArgumentsRow = (TableRenderer.FunctionArgumentsRow)row;
                this.renderFunctionArguments(functionArgumentsRow.receiverType, functionArgumentsRow.argumentTypes, result);
            }
            result.append("\n");
        }
    }

    private void renderFunctionArguments(@Nullable JetType receiverType, @NotNull List<JetType> argumentTypes, StringBuilder result) {
        boolean hasReceiver;
        boolean bl = hasReceiver = receiverType != null;
        if (hasReceiver) {
            result.append("receiver: ");
            result.append(this.getTypeRenderer().render(receiverType));
            result.append("  arguments: ");
        }
        if (argumentTypes.isEmpty()) {
            result.append("()");
            return;
        }
        result.append("(");
        Iterator<JetType> iterator = argumentTypes.iterator();
        while (iterator.hasNext()) {
            JetType argumentType = iterator.next();
            String renderedArgument = this.getTypeRenderer().render(argumentType);
            result.append(renderedArgument);
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        result.append(")");
    }

    public static TabledDescriptorRenderer create() {
        return new TabledDescriptorRenderer();
    }

    public static enum TextElementType {
        STRONG,
        ERROR,
        DEFAULT;

    }

    public static class TextRenderer
    implements TableOrTextRenderer,
    TableRenderer.TableRow {
        public final List<TextElement> elements = Lists.newArrayList();

        public TextRenderer normal(@NotNull Object text) {
            this.elements.add(new TextElement(TextElementType.DEFAULT, text.toString()));
            return this;
        }

        public TextRenderer error(@NotNull Object text) {
            this.elements.add(new TextElement(TextElementType.ERROR, text.toString()));
            return this;
        }

        public TextRenderer strong(@NotNull Object text) {
            this.elements.add(new TextElement(TextElementType.STRONG, text.toString()));
            return this;
        }

        public static class TextElement {
            public TextElementType type;
            public String text;

            public TextElement(@NotNull TextElementType type, @NotNull String text) {
                this.type = type;
                this.text = text;
            }
        }
    }

    public static class TableRenderer
    implements TableOrTextRenderer {
        public final List<TableRow> rows = Lists.newArrayList();

        public TableRenderer descriptor(CallableDescriptor descriptor) {
            this.rows.add(new DescriptorRow(descriptor));
            return this;
        }

        public TableRenderer functionArgumentTypeList(@Nullable JetType receiverType, @NotNull List<JetType> argumentTypes) {
            return this.functionArgumentTypeList(receiverType, argumentTypes, Predicates.<ConstraintPosition>alwaysFalse());
        }

        public TableRenderer functionArgumentTypeList(@Nullable JetType receiverType, @NotNull List<JetType> argumentTypes, @NotNull Predicate<ConstraintPosition> isErrorPosition) {
            this.rows.add(new FunctionArgumentsRow(receiverType, argumentTypes, isErrorPosition));
            return this;
        }

        public TableRenderer text(@NotNull String text) {
            this.rows.add(TabledDescriptorRenderer.newText().normal(text));
            return this;
        }

        public TableRenderer text(@NotNull TextRenderer textRenderer) {
            this.rows.add(textRenderer);
            return this;
        }

        public static class FunctionArgumentsRow
        implements TableRow {
            public final JetType receiverType;
            public final List<JetType> argumentTypes;
            public final Predicate<ConstraintPosition> isErrorPosition;

            public FunctionArgumentsRow(JetType receiverType, List<JetType> argumentTypes, Predicate<ConstraintPosition> isErrorPosition) {
                this.receiverType = receiverType;
                this.argumentTypes = argumentTypes;
                this.isErrorPosition = isErrorPosition;
            }
        }

        public static class DescriptorRow
        implements TableRow {
            public final CallableDescriptor descriptor;

            public DescriptorRow(CallableDescriptor descriptor) {
                this.descriptor = descriptor;
            }
        }

        public static interface TableRow {
        }
    }

    public static interface TableOrTextRenderer {
    }
}

