/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.cfg.PseudocodeTraverser;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.LocalDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.cfg.pseudocode.PseudocodeUtil;
import org.jetbrains.jet.lang.cfg.pseudocode.ReadValueInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.VariableDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.WriteValueInstruction;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.resolve.BindingContext;

public class PseudocodeVariablesData {
    private final Pseudocode pseudocode;
    private final BindingContext bindingContext;
    private final Map<Pseudocode, Set<VariableDescriptor>> declaredVariablesForDeclaration = Maps.newHashMap();
    private final Map<Pseudocode, Set<VariableDescriptor>> usedVariablesForDeclaration = Maps.newHashMap();
    private Map<Instruction, PseudocodeTraverser.Edges<Map<VariableDescriptor, VariableInitState>>> variableInitializers;

    public PseudocodeVariablesData(@NotNull Pseudocode pseudocode, @NotNull BindingContext bindingContext) {
        this.pseudocode = pseudocode;
        this.bindingContext = bindingContext;
    }

    @NotNull
    public Pseudocode getPseudocode() {
        return this.pseudocode;
    }

    @NotNull
    public Set<VariableDescriptor> getUsedVariables(@NotNull Pseudocode pseudocode) {
        Set<VariableDescriptor> usedVariables = this.usedVariablesForDeclaration.get(pseudocode);
        if (usedVariables == null) {
            final HashSet result = Sets.newHashSet();
            PseudocodeTraverser.traverse(pseudocode, PseudocodeTraverser.TraversalOrder.FORWARD, new PseudocodeTraverser.InstructionAnalyzeStrategy(){

                @Override
                public void execute(@NotNull Instruction instruction) {
                    VariableDescriptor variableDescriptor = PseudocodeUtil.extractVariableDescriptorIfAny(instruction, false, PseudocodeVariablesData.this.bindingContext);
                    if (variableDescriptor != null) {
                        result.add(variableDescriptor);
                    }
                }
            });
            usedVariables = Collections.unmodifiableSet(result);
            this.usedVariablesForDeclaration.put(pseudocode, usedVariables);
        }
        return usedVariables;
    }

    @NotNull
    public Set<VariableDescriptor> getDeclaredVariables(@NotNull Pseudocode pseudocode, boolean includeInsideLocalDeclarations) {
        if (!includeInsideLocalDeclarations) {
            return this.getUpperLevelDeclaredVariables(pseudocode);
        }
        HashSet<VariableDescriptor> declaredVariables = Sets.newHashSet();
        declaredVariables.addAll(this.getUpperLevelDeclaredVariables(pseudocode));
        for (LocalDeclarationInstruction localDeclarationInstruction : pseudocode.getLocalDeclarations()) {
            Pseudocode localPseudocode = localDeclarationInstruction.getBody();
            declaredVariables.addAll(this.getUpperLevelDeclaredVariables(localPseudocode));
        }
        return declaredVariables;
    }

    @NotNull
    private Set<VariableDescriptor> getUpperLevelDeclaredVariables(@NotNull Pseudocode pseudocode) {
        Set<VariableDescriptor> declaredVariables = this.declaredVariablesForDeclaration.get(pseudocode);
        if (declaredVariables == null) {
            declaredVariables = this.computeDeclaredVariablesForPseudocode(pseudocode);
            this.declaredVariablesForDeclaration.put(pseudocode, declaredVariables);
        }
        return declaredVariables;
    }

    @NotNull
    private Set<VariableDescriptor> computeDeclaredVariablesForPseudocode(Pseudocode pseudocode) {
        HashSet<VariableDescriptor> declaredVariables = Sets.newHashSet();
        for (Instruction instruction : pseudocode.getInstructions()) {
            JetDeclaration variableDeclarationElement;
            DeclarationDescriptor descriptor;
            if (!(instruction instanceof VariableDeclarationInstruction) || (descriptor = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, variableDeclarationElement = ((VariableDeclarationInstruction)instruction).getVariableDeclarationElement())) == null) continue;
            assert (descriptor instanceof VariableDescriptor);
            declaredVariables.add((VariableDescriptor)descriptor);
        }
        return Collections.unmodifiableSet(declaredVariables);
    }

    @NotNull
    public Map<Instruction, PseudocodeTraverser.Edges<Map<VariableDescriptor, VariableInitState>>> getVariableInitializers() {
        if (this.variableInitializers == null) {
            this.variableInitializers = this.getVariableInitializers(this.pseudocode);
        }
        return this.variableInitializers;
    }

    @NotNull
    private Map<Instruction, PseudocodeTraverser.Edges<Map<VariableDescriptor, VariableInitState>>> getVariableInitializers(@NotNull Pseudocode pseudocode) {
        Set<VariableDescriptor> usedVariables = this.getUsedVariables(pseudocode);
        Set<VariableDescriptor> declaredVariables = this.getDeclaredVariables(pseudocode, false);
        Map initialMap = Collections.emptyMap();
        Map<VariableDescriptor, VariableInitState> initialMapForStartInstruction = PseudocodeVariablesData.prepareInitializersMapForStartInstruction(usedVariables, declaredVariables);
        Map<Instruction, PseudocodeTraverser.Edges<Map<VariableDescriptor, VariableInitState>>> variableInitializersMap = PseudocodeTraverser.collectData(pseudocode, PseudocodeTraverser.TraversalOrder.FORWARD, PseudocodeTraverser.LookInsideStrategy.SKIP_LOCAL_DECLARATIONS, initialMap, initialMapForStartInstruction, new PseudocodeTraverser.InstructionDataMergeStrategy<Map<VariableDescriptor, VariableInitState>>(){

            @Override
            public PseudocodeTraverser.Edges<Map<VariableDescriptor, VariableInitState>> execute(@NotNull Instruction instruction, @NotNull Collection<Map<VariableDescriptor, VariableInitState>> incomingEdgesData) {
                Map enterInstructionData = PseudocodeVariablesData.mergeIncomingEdgesDataForInitializers(incomingEdgesData);
                Map exitInstructionData = PseudocodeVariablesData.this.addVariableInitStateFromCurrentInstructionIfAny(instruction, enterInstructionData);
                return PseudocodeTraverser.Edges.create(enterInstructionData, exitInstructionData);
            }
        });
        for (LocalDeclarationInstruction localDeclarationInstruction : pseudocode.getLocalDeclarations()) {
            Pseudocode localPseudocode = localDeclarationInstruction.getBody();
            Map<Instruction, PseudocodeTraverser.Edges<Map<VariableDescriptor, VariableInitState>>> initializersForLocalDeclaration = this.getVariableInitializers(localPseudocode);
            for (Instruction instruction : initializersForLocalDeclaration.keySet()) {
                if (variableInitializersMap.containsKey(instruction)) continue;
                variableInitializersMap.put(instruction, initializersForLocalDeclaration.get(instruction));
            }
            variableInitializersMap.putAll(initializersForLocalDeclaration);
        }
        return variableInitializersMap;
    }

    @NotNull
    private static Map<VariableDescriptor, VariableInitState> prepareInitializersMapForStartInstruction(@NotNull Collection<VariableDescriptor> usedVariables, @NotNull Collection<VariableDescriptor> declaredVariables) {
        HashMap<VariableDescriptor, VariableInitState> initialMapForStartInstruction = Maps.newHashMap();
        VariableInitState initializedForExternalVariable = VariableInitState.create(true);
        VariableInitState notInitializedForDeclaredVariable = VariableInitState.create(false);
        for (VariableDescriptor variable : usedVariables) {
            if (declaredVariables.contains(variable)) {
                initialMapForStartInstruction.put(variable, notInitializedForDeclaredVariable);
                continue;
            }
            initialMapForStartInstruction.put(variable, initializedForExternalVariable);
        }
        return initialMapForStartInstruction;
    }

    @NotNull
    private static Map<VariableDescriptor, VariableInitState> mergeIncomingEdgesDataForInitializers(@NotNull Collection<Map<VariableDescriptor, VariableInitState>> incomingEdgesData) {
        HashSet<VariableDescriptor> variablesInScope = Sets.newHashSet();
        for (Map<VariableDescriptor, VariableInitState> edgeData : incomingEdgesData) {
            variablesInScope.addAll(edgeData.keySet());
        }
        HashMap<VariableDescriptor, VariableInitState> enterInstructionData = Maps.newHashMap();
        for (VariableDescriptor variable : variablesInScope) {
            boolean isInitialized = true;
            boolean isDeclared = true;
            for (Map<VariableDescriptor, VariableInitState> edgeData : incomingEdgesData) {
                VariableInitState initState = edgeData.get(variable);
                if (initState == null) continue;
                if (!initState.isInitialized) {
                    isInitialized = false;
                }
                if (initState.isDeclared) continue;
                isDeclared = false;
            }
            enterInstructionData.put(variable, VariableInitState.create(isInitialized, isDeclared));
        }
        return enterInstructionData;
    }

    @NotNull
    private Map<VariableDescriptor, VariableInitState> addVariableInitStateFromCurrentInstructionIfAny(@NotNull Instruction instruction, @NotNull Map<VariableDescriptor, VariableInitState> enterInstructionData) {
        if (!(instruction instanceof WriteValueInstruction) && !(instruction instanceof VariableDeclarationInstruction)) {
            return enterInstructionData;
        }
        VariableDescriptor variable = PseudocodeUtil.extractVariableDescriptorIfAny(instruction, false, this.bindingContext);
        if (variable == null) {
            return enterInstructionData;
        }
        HashMap<VariableDescriptor, VariableInitState> exitInstructionData = Maps.newHashMap(enterInstructionData);
        if (instruction instanceof WriteValueInstruction) {
            VariableInitState enterInitState = enterInstructionData.get(variable);
            VariableInitState initializationAtThisElement = VariableInitState.create(((WriteValueInstruction)instruction).getElement() instanceof JetProperty, enterInitState);
            exitInstructionData.put(variable, initializationAtThisElement);
        } else {
            VariableInitState enterInitState = enterInstructionData.get(variable);
            if (enterInitState == null || !enterInitState.isInitialized || !enterInitState.isDeclared) {
                boolean isInitialized = enterInitState != null && enterInitState.isInitialized;
                VariableInitState variableDeclarationInfo = VariableInitState.create(isInitialized, true);
                exitInstructionData.put(variable, variableDeclarationInfo);
            }
        }
        return exitInstructionData;
    }

    @NotNull
    public Map<Instruction, PseudocodeTraverser.Edges<Map<VariableDescriptor, VariableUseState>>> getVariableUseStatusData() {
        HashMap<VariableDescriptor, VariableUseState> sinkInstructionData = Maps.newHashMap();
        for (VariableDescriptor usedVariable : this.getUsedVariables(this.pseudocode)) {
            sinkInstructionData.put(usedVariable, VariableUseState.UNUSED);
        }
        PseudocodeTraverser.InstructionDataMergeStrategy<Map<VariableDescriptor, VariableUseState>> collectVariableUseStatusStrategy = new PseudocodeTraverser.InstructionDataMergeStrategy<Map<VariableDescriptor, VariableUseState>>(){

            @Override
            public PseudocodeTraverser.Edges<Map<VariableDescriptor, VariableUseState>> execute(@NotNull Instruction instruction, @NotNull Collection<Map<VariableDescriptor, VariableUseState>> incomingEdgesData) {
                HashMap<VariableDescriptor, VariableUseState> enterResult = Maps.newHashMap();
                for (Map<VariableDescriptor, VariableUseState> edgeData : incomingEdgesData) {
                    for (Map.Entry<VariableDescriptor, VariableUseState> entry : edgeData.entrySet()) {
                        VariableDescriptor variableDescriptor = entry.getKey();
                        VariableUseState variableUseState = entry.getValue();
                        enterResult.put(variableDescriptor, variableUseState.merge((VariableUseState)((Object)enterResult.get(variableDescriptor))));
                    }
                }
                VariableDescriptor variableDescriptor = PseudocodeUtil.extractVariableDescriptorIfAny(instruction, true, PseudocodeVariablesData.this.bindingContext);
                if (variableDescriptor == null || !(instruction instanceof ReadValueInstruction) && !(instruction instanceof WriteValueInstruction)) {
                    return PseudocodeTraverser.Edges.create(enterResult, enterResult);
                }
                HashMap<VariableDescriptor, VariableUseState> exitResult = Maps.newHashMap(enterResult);
                if (instruction instanceof ReadValueInstruction) {
                    exitResult.put(variableDescriptor, VariableUseState.LAST_READ);
                } else {
                    VariableUseState variableUseState = (VariableUseState)((Object)enterResult.get(variableDescriptor));
                    if (variableUseState == null) {
                        variableUseState = VariableUseState.UNUSED;
                    }
                    switch (variableUseState) {
                        case UNUSED: 
                        case ONLY_WRITTEN_NEVER_READ: {
                            exitResult.put(variableDescriptor, VariableUseState.ONLY_WRITTEN_NEVER_READ);
                            break;
                        }
                        case LAST_WRITTEN: 
                        case LAST_READ: {
                            exitResult.put(variableDescriptor, VariableUseState.LAST_WRITTEN);
                        }
                    }
                }
                return PseudocodeTraverser.Edges.create(enterResult, exitResult);
            }
        };
        return PseudocodeTraverser.collectData(this.pseudocode, PseudocodeTraverser.TraversalOrder.BACKWARD, PseudocodeTraverser.LookInsideStrategy.ANALYSE_LOCAL_DECLARATIONS, Collections.emptyMap(), sinkInstructionData, collectVariableUseStatusStrategy);
    }

    public static enum VariableUseState {
        LAST_READ(3),
        LAST_WRITTEN(2),
        ONLY_WRITTEN_NEVER_READ(1),
        UNUSED(0);

        private final int importance;

        private VariableUseState(int importance) {
            this.importance = importance;
        }

        private VariableUseState merge(@Nullable VariableUseState variableUseState) {
            if (variableUseState == null || this.importance > variableUseState.importance) {
                return this;
            }
            return variableUseState;
        }

        public static boolean isUsed(@Nullable VariableUseState variableUseState) {
            return variableUseState != null && variableUseState != UNUSED;
        }
    }

    public static class VariableInitState {
        public final boolean isInitialized;
        public final boolean isDeclared;
        private static final VariableInitState VS_TT = new VariableInitState(true, true);
        private static final VariableInitState VS_TF = new VariableInitState(true, false);
        private static final VariableInitState VS_FT = new VariableInitState(false, true);
        private static final VariableInitState VS_FF = new VariableInitState(false, false);

        private VariableInitState(boolean isInitialized, boolean isDeclared) {
            this.isInitialized = isInitialized;
            this.isDeclared = isDeclared;
        }

        private static VariableInitState create(boolean isInitialized, boolean isDeclared) {
            if (isInitialized) {
                if (isDeclared) {
                    return VS_TT;
                }
                return VS_TF;
            }
            if (isDeclared) {
                return VS_FT;
            }
            return VS_FF;
        }

        private static VariableInitState create(boolean isInitialized) {
            return VariableInitState.create(isInitialized, false);
        }

        private static VariableInitState create(boolean isDeclaredHere, @Nullable VariableInitState mergedEdgesData) {
            return VariableInitState.create(true, isDeclaredHere || mergedEdgesData != null && mergedEdgesData.isDeclared);
        }
    }
}

