/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.state;

import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.BuiltinToJavaTypesMapping;
import org.jetbrains.jet.codegen.ClassBuilderFactory;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.ClassFileFactory;
import org.jetbrains.jet.codegen.SamWrapperClasses;
import org.jetbrains.jet.codegen.ScriptCodegen;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethods;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.codegen.state.Progress;
import org.jetbrains.jet.di.InjectorForJvmCodegen;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;

public class GenerationState {
    private boolean used = false;
    @NotNull
    private final Progress progress;
    @NotNull
    private final List<JetFile> files;
    @NotNull
    private final ClassBuilderMode classBuilderMode;
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final ClassFileFactory classFileFactory;
    @NotNull
    private final ScriptCodegen scriptCodegen;
    @NotNull
    private final Project project;
    @NotNull
    private final IntrinsicMethods intrinsics;
    @NotNull
    private final SamWrapperClasses samWrapperClasses = new SamWrapperClasses(this);
    @NotNull
    private final BindingTrace bindingTrace;
    @NotNull
    private final JetTypeMapper typeMapper;
    private final boolean generateNotNullAssertions;
    private final boolean generateNotNullParamAssertions;
    private final boolean generateDeclaredClasses;

    public GenerationState(Project project, ClassBuilderFactory builderFactory, BindingContext bindingContext, List<JetFile> files) {
        this(project, builderFactory, Progress.DEAF, bindingContext, files, BuiltinToJavaTypesMapping.ENABLED, true, false, true);
    }

    public GenerationState(@NotNull Project project, @NotNull ClassBuilderFactory builderFactory, @NotNull Progress progress, @NotNull BindingContext bindingContext, @NotNull List<JetFile> files, @NotNull BuiltinToJavaTypesMapping builtinToJavaTypesMapping, boolean generateNotNullAssertions, boolean generateNotNullParamAssertions, boolean generateDeclaredClasses) {
        this.project = project;
        this.progress = progress;
        this.files = files;
        this.classBuilderMode = builderFactory.getClassBuilderMode();
        this.bindingTrace = new DelegatingBindingTrace(bindingContext, "trace in GenerationState");
        this.bindingContext = this.bindingTrace.getBindingContext();
        this.typeMapper = new JetTypeMapper(this.bindingTrace, builtinToJavaTypesMapping == BuiltinToJavaTypesMapping.ENABLED, this.classBuilderMode);
        InjectorForJvmCodegen injector = new InjectorForJvmCodegen(this.typeMapper, this, builderFactory, project);
        this.scriptCodegen = injector.getScriptCodegen();
        this.intrinsics = injector.getIntrinsics();
        this.classFileFactory = injector.getClassFileFactory();
        this.generateNotNullAssertions = generateNotNullAssertions;
        this.generateNotNullParamAssertions = generateNotNullParamAssertions;
        this.generateDeclaredClasses = generateDeclaredClasses;
    }

    @NotNull
    public ClassFileFactory getFactory() {
        return this.classFileFactory;
    }

    @NotNull
    public Progress getProgress() {
        return this.progress;
    }

    @NotNull
    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NotNull
    public ClassBuilderMode getClassBuilderMode() {
        return this.classBuilderMode;
    }

    @NotNull
    public List<JetFile> getFiles() {
        return this.files;
    }

    @NotNull
    public ScriptCodegen getScriptCodegen() {
        return this.scriptCodegen;
    }

    @NotNull
    public BindingTrace getBindingTrace() {
        return this.bindingTrace;
    }

    @NotNull
    public JetTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public IntrinsicMethods getIntrinsics() {
        return this.intrinsics;
    }

    @NotNull
    public SamWrapperClasses getSamWrapperClasses() {
        return this.samWrapperClasses;
    }

    public boolean isGenerateNotNullAssertions() {
        return this.generateNotNullAssertions;
    }

    public boolean isGenerateNotNullParamAssertions() {
        return this.generateNotNullParamAssertions;
    }

    public boolean isGenerateDeclaredClasses() {
        return this.generateDeclaredClasses;
    }

    public void beforeCompile() {
        this.markUsed();
        CodegenBinding.initTrace(this.getBindingTrace(), this.getFiles());
    }

    private void markUsed() {
        if (this.used) {
            throw new IllegalStateException(GenerationState.class + " cannot be used more than once");
        }
        this.used = true;
    }

    public void destroy() {
    }
}

