/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.signature.kotlin;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.AnnotationVisitor;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;

public class JetValueParameterAnnotationWriter {
    private final AnnotationVisitor av;

    private JetValueParameterAnnotationWriter(AnnotationVisitor av) {
        this.av = av;
    }

    public void writeName(@NotNull String name) {
        if (name.length() > 0) {
            this.av.visit("name", name);
        }
    }

    public static JetValueParameterAnnotationWriter visitParameterAnnotation(MethodVisitor mv, int n) {
        return new JetValueParameterAnnotationWriter(mv.visitParameterAnnotation(n, JvmStdlibNames.JET_VALUE_PARAMETER.getDescriptor(), true));
    }

    public void writeReceiver() {
        this.av.visit("receiver", true);
    }

    public void writeType(@NotNull String kotlinSignature) {
        if (kotlinSignature.length() > 0) {
            this.av.visit("type", kotlinSignature);
        }
    }

    public void visitEnd() {
        this.av.visitEnd();
    }

    public void writeHasDefaultValue(boolean hasDefaultValue) {
        if (hasDefaultValue) {
            this.av.visit("hasDefaultValue", true);
        }
    }

    public void writeVararg(boolean vararg) {
        if (vararg) {
            this.av.visit("vararg", true);
        }
    }
}

