/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.NamespaceCodegen;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.resolve.ScriptNameUtil;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class KotlinCodegenFacade {
    public static void compileCorrectFiles(@NotNull GenerationState state, @NotNull CompilationErrorHandler errorHandler) {
        for (JetFile file : state.getFiles()) {
            if (!file.isScript()) continue;
            String string = ScriptNameUtil.classNameForScript(file);
            JetScript script = file.getScript();
            assert (script != null);
            CodegenBinding.registerClassNameForScript(state.getBindingTrace(), script, JvmClassName.byInternalName(string));
        }
        state.getScriptCodegen().registerEarlierScripts(Collections.<Pair<ScriptDescriptor, JvmClassName>>emptyList());
        state.beforeCompile();
        MultiMap<FqName, JetFile> namespaceGrouping = new MultiMap<FqName, JetFile>();
        for (JetFile jetFile : state.getFiles()) {
            if (jetFile == null) {
                throw new IllegalArgumentException("A null file given for compilation");
            }
            namespaceGrouping.putValue(JetPsiUtil.getFQName(jetFile), jetFile);
        }
        for (Map.Entry entry : namespaceGrouping.entrySet()) {
            KotlinCodegenFacade.generateNamespace(state, (FqName)entry.getKey(), (Collection)entry.getValue(), errorHandler);
        }
    }

    public static void generateNamespace(@NotNull GenerationState state, @NotNull FqName fqName, @NotNull Collection<JetFile> jetFiles, @NotNull CompilationErrorHandler errorHandler) {
        NamespaceCodegen codegen = state.getFactory().forNamespace(fqName, jetFiles);
        codegen.generate(errorHandler);
    }

    private KotlinCodegenFacade() {
    }
}

