/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.FunctionCodegen;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.PropertyCodegen;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.context.ClassContext;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.Name;

public abstract class ClassBodyCodegen
extends MemberCodegen {
    protected final JetClassOrObject myClass;
    protected final OwnerKind kind;
    protected final ClassDescriptor descriptor;
    protected final ClassBuilder v;
    protected final ClassContext context;
    private MethodVisitor clInitMethod;
    private ExpressionCodegen clInitCodegen;

    protected ClassBodyCodegen(@NotNull JetClassOrObject aClass, @NotNull ClassContext context, @NotNull ClassBuilder v, @NotNull GenerationState state, @Nullable MemberCodegen parentCodegen) {
        super(state, parentCodegen);
        this.descriptor = state.getBindingContext().get(BindingContext.CLASS, aClass);
        this.myClass = aClass;
        this.context = context;
        this.kind = context.getContextKind();
        this.v = v;
    }

    public void generate() {
        this.generateDeclaration();
        this.generateClassBody();
        this.generateSyntheticParts();
        this.generateStaticInitializer();
        this.generateRemoveInIterator();
    }

    protected abstract void generateDeclaration();

    protected void generateSyntheticParts() {
    }

    private void generateClassBody() {
        FunctionCodegen functionCodegen = new FunctionCodegen(this.context, this.v, this.state);
        PropertyCodegen propertyCodegen = new PropertyCodegen(this.context, this.v, functionCodegen, this);
        if (this.kind != OwnerKind.TRAIT_IMPL) {
            for (JetDeclaration declaration : this.myClass.getDeclarations()) {
                if (!this.shouldProcessFirst(declaration)) continue;
                this.generateDeclaration(propertyCodegen, declaration);
            }
        }
        for (JetDeclaration declaration : this.myClass.getDeclarations()) {
            if (this.shouldProcessFirst(declaration)) continue;
            this.generateDeclaration(propertyCodegen, declaration);
        }
        this.generatePrimaryConstructorProperties(propertyCodegen, this.myClass);
    }

    private boolean shouldProcessFirst(JetDeclaration declaration) {
        return false == (declaration instanceof JetProperty || declaration instanceof JetNamedFunction);
    }

    protected void generateDeclaration(PropertyCodegen propertyCodegen, JetDeclaration declaration) {
        if (declaration instanceof JetProperty || declaration instanceof JetNamedFunction) {
            this.genFunctionOrProperty(this.context, (JetTypeParameterListOwner)declaration, this.v);
        } else if (declaration instanceof JetClassOrObject) {
            if (declaration instanceof JetEnumEntry && !CodegenBinding.enumEntryNeedSubclass(this.state.getBindingContext(), (JetEnumEntry)declaration)) {
                return;
            }
            this.genClassOrObject(this.context, (JetClassOrObject)declaration);
        } else if (declaration instanceof JetClassObject) {
            this.genClassOrObject(this.context, ((JetClassObject)declaration).getObjectDeclaration());
        }
    }

    private void generatePrimaryConstructorProperties(PropertyCodegen propertyCodegen, JetClassOrObject origin) {
        boolean isAnnotation = origin instanceof JetClass && ((JetClass)origin).isAnnotation();
        for (JetParameter p : this.getPrimaryConstructorParameters()) {
            PropertyDescriptor propertyDescriptor;
            if (p.getValOrVarNode() == null || (propertyDescriptor = this.state.getBindingContext().get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, p)) == null) continue;
            if (!isAnnotation) {
                propertyCodegen.generatePrimaryConstructorProperty(p, propertyDescriptor);
                continue;
            }
            Type type = this.state.getTypeMapper().mapType(propertyDescriptor);
            this.v.newMethod(p, 1025, p.getName(), "()" + type.getDescriptor(), null, null);
        }
    }

    @NotNull
    protected List<JetParameter> getPrimaryConstructorParameters() {
        if (this.myClass instanceof JetClass) {
            return ((JetClass)this.myClass).getPrimaryConstructorParameters();
        }
        return Collections.emptyList();
    }

    private void generateStaticInitializer() {
        if (this.clInitMethod != null) {
            this.createOrGetClInitMethod();
            if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL) {
                ExpressionCodegen codegen = this.createOrGetClInitCodegen();
                this.createOrGetClInitMethod().visitInsn(177);
                FunctionCodegen.endVisit(codegen.v, "static initializer", this.myClass);
            }
        }
    }

    @Nullable
    protected MethodVisitor createOrGetClInitMethod() {
        if (this.clInitMethod == null) {
            this.clInitMethod = this.v.newMethod(null, 8, "<clinit>", "()V", null, null);
        }
        return this.clInitMethod;
    }

    @Nullable
    protected ExpressionCodegen createOrGetClInitCodegen() {
        assert (this.state.getClassBuilderMode() == ClassBuilderMode.FULL);
        if (this.state.getClassBuilderMode() == ClassBuilderMode.FULL && this.clInitCodegen == null) {
            MethodVisitor method = this.createOrGetClInitMethod();
            method.visitCode();
            SimpleFunctionDescriptorImpl clInit = new SimpleFunctionDescriptorImpl(this.descriptor, Collections.<AnnotationDescriptor>emptyList(), Name.special("<clinit>"), CallableMemberDescriptor.Kind.SYNTHESIZED);
            clInit.initialize(null, null, Collections.emptyList(), Collections.<ValueParameterDescriptor>emptyList(), null, null, Visibilities.PRIVATE, false);
            this.clInitCodegen = new ExpressionCodegen(method, new FrameMap(), Type.VOID_TYPE, this.context.intoFunction(clInit), this.state);
        }
        return this.clInitCodegen;
    }

    private void generateRemoveInIterator() {
        if (DescriptorUtils.isIteratorWithoutRemoveImpl(this.descriptor)) {
            MethodVisitor mv = this.v.getVisitor().visitMethod(1, "remove", "()V", null, null);
            AsmUtil.genMethodThrow(mv, "java/lang/UnsupportedOperationException", "Mutating method called on a Kotlin Iterator");
        }
    }
}

