/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.compiler;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.asJava.KotlinLightClassForExplicitDeclaration;
import org.jetbrains.jet.asJava.LightClassConstructionContext;
import org.jetbrains.jet.asJava.LightClassGenerationSupport;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.JvmAbi;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class CliLightClassGenerationSupport
extends LightClassGenerationSupport {
    private BindingTrace trace;

    public static CliLightClassGenerationSupport getInstanceForCli(@NotNull Project project) {
        return ServiceManager.getService(project, CliLightClassGenerationSupport.class);
    }

    @NotNull
    public BindingTrace getTrace() {
        if (this.trace == null) {
            this.trace = new BindingTraceContext();
        }
        return this.trace;
    }

    public void newBindingTrace() {
        assert (ApplicationManager.getApplication().isUnitTestMode()) : "Mutating project service's state shouldn't happen other than in tests";
        this.trace = null;
    }

    @Override
    @NotNull
    public LightClassConstructionContext analyzeRelevantCode(@NotNull Collection<JetFile> files) {
        return new LightClassConstructionContext(this.getTrace().getBindingContext(), null);
    }

    @Override
    @NotNull
    public Collection<JetClassOrObject> findClassOrObjectDeclarations(@NotNull FqName fqName, @NotNull GlobalSearchScope searchScope) {
        PsiElement element;
        ClassDescriptor classDescriptor = this.getTrace().get(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, fqName);
        if (classDescriptor != null && (element = BindingContextUtils.classDescriptorToDeclaration(this.trace.getBindingContext(), classDescriptor)) != null && PsiSearchScopeUtil.isInScope(searchScope, element)) {
            return Collections.singletonList((JetClassOrObject)element);
        }
        if (JvmAbi.isClassObjectFqName(fqName)) {
            Collection<JetClassOrObject> parentClasses = this.findClassOrObjectDeclarations(fqName.parent(), searchScope);
            return ContainerUtil.mapNotNull(parentClasses, new Function<JetClassOrObject, JetClassOrObject>(){

                @Override
                public JetClassOrObject fun(JetClassOrObject classOrObject) {
                    JetClass jetClass;
                    JetClassObject classObject;
                    if (classOrObject instanceof JetClass && (classObject = (jetClass = (JetClass)classOrObject).getClassObject()) != null) {
                        return classObject.getObjectDeclaration();
                    }
                    return null;
                }
            });
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Collection<JetFile> findFilesForPackage(@NotNull FqName fqName, final @NotNull GlobalSearchScope searchScope) {
        Collection<JetFile> files;
        NamespaceDescriptor namespaceDescriptor = this.getTrace().get(BindingContext.FQNAME_TO_NAMESPACE_DESCRIPTOR, fqName);
        if (namespaceDescriptor != null && (files = this.getTrace().get(BindingContext.NAMESPACE_TO_FILES, namespaceDescriptor)) != null) {
            return Collections2.filter(files, new Predicate<JetFile>(){

                @Override
                public boolean apply(JetFile input) {
                    return PsiSearchScopeUtil.isInScope(searchScope, (PsiElement)input);
                }
            });
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Collection<JetClassOrObject> findClassOrObjectDeclarationsInPackage(@NotNull FqName packageFqName, @NotNull GlobalSearchScope searchScope) {
        Collection<JetFile> files = this.findFilesForPackage(packageFqName, searchScope);
        SmartList<JetClassOrObject> result = new SmartList<JetClassOrObject>();
        for (JetFile file : files) {
            for (JetDeclaration declaration : file.getDeclarations()) {
                if (!(declaration instanceof JetClassOrObject)) continue;
                result.add((JetClassOrObject)declaration);
            }
        }
        return result;
    }

    @Override
    public boolean packageExists(@NotNull FqName fqName, @NotNull GlobalSearchScope scope) {
        return this.getTrace().get(BindingContext.FQNAME_TO_NAMESPACE_DESCRIPTOR, fqName) != null;
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackages(@NotNull FqName fqn, @NotNull GlobalSearchScope scope) {
        NamespaceDescriptor namespaceDescriptor = this.getTrace().get(BindingContext.FQNAME_TO_NAMESPACE_DESCRIPTOR, fqn);
        if (namespaceDescriptor == null) {
            return Collections.emptyList();
        }
        Collection<DeclarationDescriptor> allDescriptors = namespaceDescriptor.getMemberScope().getAllDescriptors();
        return ContainerUtil.mapNotNull(allDescriptors, new Function<DeclarationDescriptor, FqName>(){

            @Override
            public FqName fun(DeclarationDescriptor input) {
                if (input instanceof NamespaceDescriptor) {
                    return DescriptorUtils.getFQName(input).toSafe();
                }
                return null;
            }
        });
    }

    @Override
    @Nullable
    public PsiClass getPsiClass(@NotNull JetClassOrObject classOrObject) {
        return KotlinLightClassForExplicitDeclaration.create(classOrObject.getManager(), classOrObject);
    }
}

