/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.asJava;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.light.AbstractLightClass;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.light.LightTypeParameterListBuilder;
import com.intellij.psi.stubs.PsiClassHolderFileStub;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.asJava.KotlinJavaFileStubProvider;
import org.jetbrains.jet.asJava.KotlinLightClass;
import org.jetbrains.jet.asJava.KotlinLightTypeParameter;
import org.jetbrains.jet.asJava.LightClassUtil;
import org.jetbrains.jet.codegen.binding.PsiCodegenPredictor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.JetJavaMirrorMarker;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.plugin.JetLanguage;

public class KotlinLightClassForExplicitDeclaration
extends AbstractLightClass
implements KotlinLightClass,
JetJavaMirrorMarker {
    private static final Key<CachedValue<PsiJavaFileStub>> JAVA_API_STUB = Key.create("JAVA_API_STUB");
    private final FqName classFqName;
    private final JetClassOrObject classOrObject;
    private PsiClass delegate;
    @Nullable
    private PsiModifierList modifierList;
    private NullableLazyValue<PsiTypeParameterList> typeParameterList = new NullableLazyValue<PsiTypeParameterList>(){

        @Override
        @Nullable
        protected PsiTypeParameterList compute() {
            LightTypeParameterListBuilder builder = new LightTypeParameterListBuilder(KotlinLightClassForExplicitDeclaration.this.getManager(), KotlinLightClassForExplicitDeclaration.this.getLanguage());
            if (KotlinLightClassForExplicitDeclaration.this.classOrObject instanceof JetTypeParameterListOwner) {
                JetTypeParameterListOwner typeParameterListOwner = (JetTypeParameterListOwner)((Object)KotlinLightClassForExplicitDeclaration.this.classOrObject);
                List<JetTypeParameter> parameters = typeParameterListOwner.getTypeParameters();
                for (int i = 0; i < parameters.size(); ++i) {
                    JetTypeParameter jetTypeParameter = parameters.get(i);
                    String name = jetTypeParameter.getName();
                    String safeName = name == null ? "__no_name__" : name;
                    builder.addParameter(new KotlinLightTypeParameter(KotlinLightClassForExplicitDeclaration.this, i, safeName));
                }
            }
            return builder;
        }
    };
    private final NullableLazyValue<PsiFile> _containingFile = new NullableLazyValue<PsiFile>(){

        @Override
        @Nullable
        protected PsiFile compute() {
            VirtualFile virtualFile = KotlinLightClassForExplicitDeclaration.this.classOrObject.getContainingFile().getVirtualFile();
            assert (virtualFile != null) : "No virtual file for " + KotlinLightClassForExplicitDeclaration.access$000(KotlinLightClassForExplicitDeclaration.this).getText();
            return new ClsFileImpl((PsiManagerImpl)KotlinLightClassForExplicitDeclaration.this.getManager(), new ClassFileViewProvider(KotlinLightClassForExplicitDeclaration.this.getManager(), virtualFile)){

                @Override
                @NotNull
                public String getPackageName() {
                    return JetPsiUtil.getFQName((JetFile)KotlinLightClassForExplicitDeclaration.this.classOrObject.getContainingFile()).asString();
                }

                @Override
                @NotNull
                public PsiClassHolderFileStub getStub() {
                    return KotlinLightClassForExplicitDeclaration.this.getJavaFileStub();
                }
            };
        }
    };

    @Nullable
    public static KotlinLightClassForExplicitDeclaration create(@NotNull PsiManager manager, @NotNull JetClassOrObject classOrObject) {
        if (LightClassUtil.belongsToKotlinBuiltIns((JetFile)classOrObject.getContainingFile())) {
            return null;
        }
        JvmClassName jvmClassName = PsiCodegenPredictor.getPredefinedJvmClassName(classOrObject);
        if (jvmClassName == null) {
            return null;
        }
        return new KotlinLightClassForExplicitDeclaration(manager, jvmClassName.getFqName(), classOrObject);
    }

    private KotlinLightClassForExplicitDeclaration(@NotNull PsiManager manager, @NotNull FqName name, @NotNull JetClassOrObject classOrObject) {
        super(manager, JetLanguage.INSTANCE);
        this.classFqName = name;
        this.classOrObject = classOrObject;
    }

    @NotNull
    public JetClassOrObject getJetClassOrObject() {
        return this.classOrObject;
    }

    @Override
    @NotNull
    public FqName getFqName() {
        return this.classFqName;
    }

    @Override
    @NotNull
    public PsiElement copy() {
        return new KotlinLightClassForExplicitDeclaration(this.getManager(), this.classFqName, this.classOrObject);
    }

    @Override
    @NotNull
    public PsiClass getDelegate() {
        if (this.delegate == null) {
            PsiJavaFileStub javaFileStub = this.getJavaFileStub();
            PsiClass psiClass = LightClassUtil.findClass(this.classFqName, javaFileStub);
            if (psiClass == null) {
                JetClassOrObject outermostClassOrObject = KotlinLightClassForExplicitDeclaration.getOutermostClassOrObject(this.classOrObject);
                throw new IllegalStateException("Class was not found " + this.classFqName + "\n" + "in " + outermostClassOrObject.getContainingFile().getText() + "\n" + "stub: \n" + ((PsiJavaFile)javaFileStub.getPsi()).getText());
            }
            this.delegate = psiClass;
        }
        return this.delegate;
    }

    @NotNull
    private PsiJavaFileStub getJavaFileStub() {
        JetClassOrObject outermostClassOrObject = KotlinLightClassForExplicitDeclaration.getOutermostClassOrObject(this.classOrObject);
        return CachedValuesManager.getManager(this.getProject()).getCachedValue(outermostClassOrObject, JAVA_API_STUB, KotlinJavaFileStubProvider.createForDeclaredTopLevelClass(outermostClassOrObject), false);
    }

    @NotNull
    private static JetClassOrObject getOutermostClassOrObject(@NotNull JetClassOrObject classOrObject) {
        JetClassOrObject outermostClass = JetPsiUtil.getOutermostClassOrObject(classOrObject);
        if (outermostClass == null) {
            throw new IllegalStateException("Attempt to build a light class for a local class: " + classOrObject.getText());
        }
        return outermostClass;
    }

    @Override
    public PsiFile getContainingFile() {
        return this._containingFile.getValue();
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        return this.classOrObject;
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return another instanceof PsiClass && Comparing.equal(((PsiClass)another).getQualifiedName(), this.getQualifiedName());
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public Icon getElementIcon(int flags) {
        throw new UnsupportedOperationException("This should be done byt JetIconProvider");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KotlinLightClassForExplicitDeclaration aClass = (KotlinLightClassForExplicitDeclaration)o;
        return this.classFqName.equals(aClass.classFqName);
    }

    public int hashCode() {
        return this.classFqName.hashCode();
    }

    @Override
    @Nullable
    public PsiClass getContainingClass() {
        if (this.classOrObject.getParent() == this.classOrObject.getContainingFile()) {
            return null;
        }
        return super.getContainingClass();
    }

    @Override
    @Nullable
    public PsiElement getParent() {
        if (this.classOrObject.getParent() == this.classOrObject.getContainingFile()) {
            return this.getContainingFile();
        }
        return this.getContainingClass();
    }

    @Override
    @Nullable
    public PsiTypeParameterList getTypeParameterList() {
        return this.typeParameterList.getValue();
    }

    @Override
    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameterList typeParameterList = this.getTypeParameterList();
        return typeParameterList == null ? PsiTypeParameter.EMPTY_ARRAY : typeParameterList.getTypeParameters();
    }

    @Override
    @Nullable
    public String getName() {
        return this.classFqName.shortName().asString();
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return this.classFqName.asString();
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        if (this.modifierList == null) {
            this.modifierList = new LightModifierList(this.getManager(), JetLanguage.INSTANCE, this.computeModifiers());
        }
        return this.modifierList;
    }

    @NotNull
    private String[] computeModifiers() {
        boolean nestedClass = this.classOrObject.getParent() != this.classOrObject.getContainingFile();
        HashSet<Object> psiModifiers = Sets.newHashSet();
        ArrayList<Pair> jetTokenToPsiModifier = Lists.newArrayList(Pair.create(JetTokens.PUBLIC_KEYWORD, "public"), Pair.create(JetTokens.INTERNAL_KEYWORD, "public"), Pair.create(JetTokens.PROTECTED_KEYWORD, "protected"), Pair.create(JetTokens.FINAL_KEYWORD, "final"));
        for (Pair tokenAndModifier : jetTokenToPsiModifier) {
            if (!this.classOrObject.hasModifier((JetToken)tokenAndModifier.first)) continue;
            psiModifiers.add(tokenAndModifier.second);
        }
        if (this.classOrObject.hasModifier(JetTokens.PRIVATE_KEYWORD)) {
            psiModifiers.add(nestedClass ? "private" : "public");
        }
        if (!psiModifiers.contains("private") && !psiModifiers.contains("protected")) {
            psiModifiers.add("public");
        }
        if (this.isAbstract(this.classOrObject)) {
            psiModifiers.add("abstract");
        } else if (!this.classOrObject.hasModifier(JetTokens.OPEN_KEYWORD)) {
            psiModifiers.add("final");
        }
        if (nestedClass && !this.classOrObject.hasModifier(JetTokens.INNER_KEYWORD)) {
            psiModifiers.add("static");
        }
        return psiModifiers.toArray(new String[psiModifiers.size()]);
    }

    private boolean isAbstract(@NotNull JetClassOrObject object) {
        return object.hasModifier(JetTokens.ABSTRACT_KEYWORD) || this.isInterface();
    }

    @Override
    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    public boolean isDeprecated() {
        JetModifierList jetModifierList = this.classOrObject.getModifierList();
        if (jetModifierList == null) {
            return false;
        }
        ClassDescriptor deprecatedAnnotation = KotlinBuiltIns.getInstance().getDeprecatedAnnotation();
        String deprecatedName = deprecatedAnnotation.getName().asString();
        FqNameUnsafe deprecatedFqName = DescriptorUtils.getFQName(deprecatedAnnotation);
        for (JetAnnotationEntry annotationEntry : jetModifierList.getAnnotationEntries()) {
            FqName fqName;
            JetTypeElement typeElement;
            JetTypeReference typeReference = annotationEntry.getTypeReference();
            if (typeReference == null || !((typeElement = typeReference.getTypeElement()) instanceof JetUserType) || (fqName = JetPsiUtil.toQualifiedName((JetUserType)typeElement)) == null) continue;
            if (deprecatedFqName.equals(fqName.toUnsafe())) {
                return true;
            }
            if (!deprecatedName.equals(fqName.asString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInterface() {
        if (!(this.classOrObject instanceof JetClass)) {
            return false;
        }
        JetClass jetClass = (JetClass)this.classOrObject;
        return jetClass.isTrait() || jetClass.isAnnotation();
    }

    @Override
    public boolean isAnnotationType() {
        return this.classOrObject instanceof JetClass && ((JetClass)this.classOrObject).isAnnotation();
    }

    @Override
    public boolean isEnum() {
        return this.classOrObject instanceof JetClass && ((JetClass)this.classOrObject).isEnum();
    }

    @Override
    public boolean hasTypeParameters() {
        return this.classOrObject instanceof JetClass && !((JetClass)this.classOrObject).getTypeParameters().isEmpty();
    }

    @Override
    public boolean isValid() {
        return this.classOrObject.isValid();
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        return super.setName(name);
    }

    @Override
    public String toString() {
        try {
            return KotlinLightClass.class.getSimpleName() + ":" + this.getQualifiedName();
        }
        catch (Throwable e) {
            return KotlinLightClass.class.getSimpleName() + ":" + e.toString();
        }
    }
}

