/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.asJava;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.asJava.FakeLightClassForFileOfPackage;
import org.jetbrains.jet.asJava.JetLightPackage;
import org.jetbrains.jet.asJava.KotlinLightClassForPackage;
import org.jetbrains.jet.asJava.LightClassGenerationSupport;
import org.jetbrains.jet.asJava.LightClassUtil;
import org.jetbrains.jet.codegen.NamespaceCodegen;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.java.JavaPsiFacadeKotlinHacks;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.util.QualifiedNamesUtil;

public class JavaElementFinder
extends PsiElementFinder
implements JavaPsiFacadeKotlinHacks.KotlinFinderMarker {
    private final Project project;
    private final PsiManager psiManager;
    private final LightClassGenerationSupport lightClassGenerationSupport;

    @NotNull
    public static JavaElementFinder getInstance(@NotNull Project project) {
        PsiElementFinder[] extensions;
        for (PsiElementFinder extension : extensions = Extensions.getArea(project).getExtensionPoint(PsiElementFinder.EP_NAME).getExtensions()) {
            if (!(extension instanceof JavaElementFinder)) continue;
            return (JavaElementFinder)extension;
        }
        throw new IllegalStateException(JavaElementFinder.class.getSimpleName() + " is not found for project " + project);
    }

    public JavaElementFinder(@NotNull Project project, @NotNull LightClassGenerationSupport lightClassGenerationSupport) {
        this.project = project;
        this.psiManager = PsiManager.getInstance(project);
        this.lightClassGenerationSupport = lightClassGenerationSupport;
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass[] allClasses = this.findClasses(qualifiedName, scope);
        return allClasses.length > 0 ? allClasses[0] : null;
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedNameString, @NotNull GlobalSearchScope scope) {
        if (!QualifiedNamesUtil.isValidJavaFqName(qualifiedNameString)) {
            return PsiClass.EMPTY_ARRAY;
        }
        SmartList<PsiClass> answer = new SmartList<PsiClass>();
        FqName qualifiedName = new FqName(qualifiedNameString);
        this.findClassesAndObjects(qualifiedName, scope, answer);
        if (PackageClassUtils.isPackageClass(qualifiedName)) {
            this.findPackageClass(qualifiedName.parent(), scope, answer);
        }
        return answer.toArray(new PsiClass[answer.size()]);
    }

    private void findClassesAndObjects(FqName qualifiedName, GlobalSearchScope scope, List<PsiClass> answer) {
        Collection<JetClassOrObject> classOrObjectDeclarations = this.lightClassGenerationSupport.findClassOrObjectDeclarations(qualifiedName, scope);
        for (JetClassOrObject declaration : classOrObjectDeclarations) {
            PsiClass lightClass;
            if (declaration instanceof JetEnumEntry || (lightClass = LightClassUtil.getPsiClass(declaration)) == null) continue;
            answer.add(lightClass);
        }
    }

    private void findPackageClass(FqName qualifiedName, GlobalSearchScope scope, List<PsiClass> answer) {
        KotlinLightClassForPackage lightClass;
        Collection<JetFile> filesForPackage = this.lightClassGenerationSupport.findFilesForPackage(qualifiedName, scope);
        if (!filesForPackage.isEmpty() && NamespaceCodegen.shouldGenerateNSClass(filesForPackage) && (lightClass = KotlinLightClassForPackage.create(this.psiManager, qualifiedName, scope, filesForPackage)) != null) {
            answer.add(lightClass);
            if (filesForPackage.size() > 1) {
                for (JetFile file : filesForPackage) {
                    FakeLightClassForFileOfPackage fakeLightClass = new FakeLightClassForFileOfPackage(this.psiManager, lightClass, file);
                    answer.add(fakeLightClass);
                }
            }
        }
    }

    @Override
    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<JetClassOrObject> declarations = this.lightClassGenerationSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope);
        HashSet<String> answer = Sets.newHashSet();
        answer.add(PackageClassUtils.getPackageClassName(packageFQN));
        for (JetClassOrObject declaration : declarations) {
            String name = declaration.getName();
            if (name == null) continue;
            answer.add(name);
        }
        return answer;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedNameString) {
        if (!QualifiedNamesUtil.isValidJavaFqName(qualifiedNameString)) {
            return null;
        }
        FqName fqName = new FqName(qualifiedNameString);
        GlobalSearchScope allScope = GlobalSearchScope.allScope(this.project);
        if (this.lightClassGenerationSupport.packageExists(fqName, allScope)) {
            return new JetLightPackage(this.psiManager, fqName, allScope);
        }
        return null;
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, final @NotNull GlobalSearchScope scope) {
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<FqName> subpackages = this.lightClassGenerationSupport.getSubPackages(packageFQN, scope);
        Collection<PsiPackage> answer = Collections2.transform(subpackages, new Function<FqName, PsiPackage>(){

            @Override
            public PsiPackage apply(@Nullable FqName input) {
                return new JetLightPackage(JavaElementFinder.this.psiManager, input, scope);
            }
        });
        return answer.toArray(new PsiPackage[answer.size()]);
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        SmartList<PsiClass> answer = new SmartList<PsiClass>();
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        this.findPackageClass(packageFQN, scope, answer);
        Collection<JetClassOrObject> declarations = this.lightClassGenerationSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope);
        for (JetClassOrObject declaration : declarations) {
            PsiClass aClass = LightClassUtil.getPsiClass(declaration);
            if (aClass == null) continue;
            answer.add(aClass);
        }
        return answer.toArray(new PsiClass[answer.size()]);
    }
}

