/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.util.Stack;
import org.jdom.Namespace;

class NamespaceStack {
    private Stack prefixes = new Stack();
    private Stack uris = new Stack();

    NamespaceStack() {
    }

    public void push(Namespace ns) {
        this.prefixes.push(ns.getPrefix());
        this.uris.push(ns.getURI());
    }

    public String pop() {
        String prefix = (String)this.prefixes.pop();
        this.uris.pop();
        return prefix;
    }

    public int size() {
        return this.prefixes.size();
    }

    public String getURI(String prefix) {
        int index = this.prefixes.lastIndexOf(prefix);
        if (index == -1) {
            return null;
        }
        String uri = (String)this.uris.elementAt(index);
        return uri;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String sep = System.getProperty("line.separator");
        buf.append(new StringBuffer().append("Stack: ").append(this.prefixes.size()).append(sep).toString());
        for (int i = 0; i < this.prefixes.size(); ++i) {
            buf.append(new StringBuffer().append(this.prefixes.elementAt(i)).append("&").append(this.uris.elementAt(i)).append(sep).toString());
        }
        return buf.toString();
    }
}

