/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.DoubleIterator;
import jet.DoubleProgressionIterator;
import jet.Progression;
import org.jetbrains.jet.rt.annotation.AssertInvisibleInResolver;

@AssertInvisibleInResolver
public class DoubleProgression
implements Progression<Double> {
    private final double start;
    private final double end;
    private final double increment;

    public DoubleProgression(double start, double end, double increment) {
        if (Double.isNaN(increment)) {
            throw new IllegalArgumentException("Increment must be not NaN");
        }
        if (increment == 0.0 || increment == -0.0) {
            throw new IllegalArgumentException("Increment must be non-zero: " + increment);
        }
        this.start = start;
        this.end = end;
        this.increment = increment;
    }

    @Override
    public Double getStart() {
        return this.start;
    }

    @Override
    public Double getEnd() {
        return this.end;
    }

    @Override
    public Double getIncrement() {
        return this.increment;
    }

    public DoubleIterator iterator() {
        return new DoubleProgressionIterator(this.start, this.end, this.increment);
    }

    public String toString() {
        if (this.increment > 0.0) {
            return this.start + ".." + this.end + " step " + this.increment;
        }
        return this.start + " downTo " + this.end + " step " + -this.increment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleProgression doubles = (DoubleProgression)o;
        if (Double.compare(doubles.end, this.end) != 0) {
            return false;
        }
        if (Double.compare(doubles.increment, this.increment) != 0) {
            return false;
        }
        return Double.compare(doubles.start, this.start) == 0;
    }

    public int hashCode() {
        long temp = this.start != 0.0 ? Double.doubleToLongBits(this.start) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.end != 0.0 ? Double.doubleToLongBits(this.end) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.increment != 0.0 ? Double.doubleToLongBits(this.increment) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

