/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.CharIterator;
import jet.CharProgressionIterator;
import jet.Progression;
import org.jetbrains.jet.rt.annotation.AssertInvisibleInResolver;

@AssertInvisibleInResolver
public class CharProgression
implements Progression<Character> {
    private final char start;
    private final char end;
    private final int increment;

    public CharProgression(char start, char end, int increment) {
        if (increment == 0) {
            throw new IllegalArgumentException("Increment must be non-zero: " + increment);
        }
        this.start = start;
        this.end = end;
        this.increment = increment;
    }

    @Override
    public Character getStart() {
        return Character.valueOf(this.start);
    }

    @Override
    public Character getEnd() {
        return Character.valueOf(this.end);
    }

    @Override
    public Integer getIncrement() {
        return this.increment;
    }

    public CharIterator iterator() {
        return new CharProgressionIterator(this.start, this.end, this.increment);
    }

    public String toString() {
        if (this.increment > 0) {
            return this.start + ".." + this.end + " step " + this.increment;
        }
        return this.start + " downTo " + this.end + " step " + -this.increment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharProgression that = (CharProgression)o;
        if (this.end != that.end) {
            return false;
        }
        if (this.increment != that.increment) {
            return false;
        }
        return this.start == that.start;
    }

    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        result = 31 * result + this.increment;
        return result;
    }
}

