/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.ByteIterator;
import jet.ByteProgressionIterator;
import jet.Progression;
import org.jetbrains.jet.rt.annotation.AssertInvisibleInResolver;

@AssertInvisibleInResolver
public class ByteProgression
implements Progression<Byte> {
    private final byte start;
    private final byte end;
    private final int increment;

    public ByteProgression(byte start, byte end, int increment) {
        if (increment == 0) {
            throw new IllegalArgumentException("Increment must be non-zero: " + increment);
        }
        this.start = start;
        this.end = end;
        this.increment = increment;
    }

    @Override
    public Byte getStart() {
        return this.start;
    }

    @Override
    public Byte getEnd() {
        return this.end;
    }

    @Override
    public Integer getIncrement() {
        return this.increment;
    }

    public ByteIterator iterator() {
        return new ByteProgressionIterator(this.start, this.end, this.increment);
    }

    public String toString() {
        if (this.increment > 0) {
            return this.start + ".." + this.end + " step " + this.increment;
        }
        return this.start + " downTo " + this.end + " step " + -this.increment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteProgression bytes = (ByteProgression)o;
        if (this.end != bytes.end) {
            return false;
        }
        if (this.increment != bytes.increment) {
            return false;
        }
        return this.start == bytes.start;
    }

    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        result = 31 * result + this.increment;
        return result;
    }
}

