/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TDoubleHash;
import gnu.trove.TDoubleObjectProcedure;
import java.io.Serializable;

public class TDoubleObjectHashMap<V>
extends TDoubleHash
implements Serializable {
    protected transient V[] _values;

    @Override
    public TDoubleObjectHashMap<V> clone() {
        TDoubleObjectHashMap m = (TDoubleObjectHashMap)super.clone();
        m._values = (Object[])this._values.clone();
        return m;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        return capacity;
    }

    public V put(double key, V value) {
        V previous = null;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        double[] oldKeys = this._set;
        V[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new double[newCapacity];
        this._values = new Object[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            double o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
            this._states[index] = 1;
        }
    }

    public V get(double key) {
        int index = this.index(key);
        return index < 0 ? null : (V)this._values[index];
    }

    @Override
    public void clear() {
        super.clear();
        double[] keys = this._set;
        V[] vals = this._values;
        byte[] states = this._states;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0.0;
            vals[i] = null;
            states[i] = 0;
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TDoubleObjectHashMap)) {
            return false;
        }
        TDoubleObjectHashMap that = (TDoubleObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index) {
        this._values[index] = null;
        super.removeAt(index);
    }

    public boolean forEachEntry(TDoubleObjectProcedure<V> procedure) {
        byte[] states = this._states;
        double[] keys = this._set;
        V[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    private static final class EqProcedure
    implements TDoubleObjectProcedure {
        private final TDoubleObjectHashMap _otherMap;

        EqProcedure(TDoubleObjectHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(double key, Object value) {
            int index = this._otherMap.index(key);
            return index >= 0 && this.eq(value, this._otherMap.get(key));
        }

        private final boolean eq(Object o1, Object o2) {
            return o1 == o2 || o1 != null && o1.equals(o2);
        }
    }

    private final class HashProcedure
    implements TDoubleObjectProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(double key, Object value) {
            this.h += TDoubleObjectHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

