/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TDoubleHashingStrategy;
import gnu.trove.TPrimitiveHash;
import java.io.Serializable;

public abstract class TDoubleHash
extends TPrimitiveHash
implements TDoubleHashingStrategy,
Serializable {
    protected transient double[] _set;
    protected TDoubleHashingStrategy _hashingStrategy = this;

    @Override
    public Object clone() {
        TDoubleHash h = (TDoubleHash)super.clone();
        h._set = (double[])this._set.clone();
        return h;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new double[capacity];
        return capacity;
    }

    @Override
    protected void removeAt(int index) {
        this._set[index] = 0.0;
        super.removeAt(index);
    }

    protected int index(double val) {
        byte[] states = this._states;
        double[] set = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] != 0 && (states[index] == 2 || set[index] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (states[index] != 0 && (states[index] == 2 || set[index] != val));
        }
        return states[index] == 0 ? -1 : index;
    }

    protected int insertionIndex(double val) {
        byte[] states = this._states;
        double[] set = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] == 0) {
            return index;
        }
        if (states[index] == 1 && set[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        do {
            if ((index -= probe) >= 0) continue;
            index += length;
        } while (states[index] == 1 && set[index] != val);
        if (states[index] == 2) {
            int firstRemoved = index;
            while (states[index] != 0 && (states[index] == 2 || set[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
            return states[index] == 1 ? -index - 1 : firstRemoved;
        }
        return states[index] == 1 ? -index - 1 : index;
    }

    @Override
    public final int computeHashCode(double val) {
        return HashFunctions.hash(val);
    }
}

