/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.util.ArrayList;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

class OptionTagBinding
implements Binding {
    private static final Logger LOG = Logger.getInstance("#" + OptionTagBinding.class.getName());
    private final Accessor accessor;
    private final String myName;
    private final Binding myBinding;
    private final String myTagName;
    private final String myNameAttribute;
    private final String myValueAttribute;

    public OptionTagBinding(Accessor accessor, @Nullable OptionTag optionTag) {
        this.accessor = accessor;
        this.myBinding = XmlSerializerImpl.getBinding(accessor);
        if (optionTag != null) {
            String name = optionTag.value();
            this.myName = name.isEmpty() ? accessor.getName() : name;
            this.myTagName = optionTag.tag();
            this.myNameAttribute = optionTag.nameAttribute();
            this.myValueAttribute = optionTag.valueAttribute();
        } else {
            this.myName = accessor.getName();
            this.myTagName = "option";
            this.myNameAttribute = "name";
            this.myValueAttribute = "value";
        }
    }

    @Override
    public Object deserialize(Object o, Object ... nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xmlb/OptionTagBinding.deserialize must not be null");
        }
        if (nodes.length > 1) {
            LOG.info("Duplicate options for " + o + " will be ignored");
        }
        assert (nodes.length != 0) : "Empty nodes passed to: " + this;
        Element element = (Element)nodes[0];
        Attribute valueAttr = element.getAttribute(this.myValueAttribute);
        if (valueAttr != null) {
            Object value = this.myBinding.deserialize(o, valueAttr);
            this.accessor.write(o, value);
        } else {
            Content[] childElements = JDOMUtil.getContent(element);
            ArrayList<Content> children = new ArrayList<Content>();
            for (Content child : childElements) {
                if (XmlSerializerImpl.isIgnoredNode(child)) continue;
                children.add(child);
            }
            if (children.size() > 0) {
                Object value = this.myBinding.deserialize(this.accessor.read(o), ArrayUtil.toObjectArray(children));
                this.accessor.write(o, value);
            } else {
                this.accessor.write(o, null);
            }
        }
        return o;
    }

    @Override
    public boolean isBoundTo(Object node) {
        if (!(node instanceof Element)) {
            return false;
        }
        Element e = (Element)node;
        if (!e.getName().equals(this.myTagName)) {
            return false;
        }
        String name = e.getAttributeValue(this.myNameAttribute);
        return name != null && name.equals(this.myName);
    }

    @Override
    public Class getBoundNodeType() {
        throw new UnsupportedOperationException("Method getBoundNodeType is not supported in " + this.getClass());
    }

    @Override
    public void init() {
    }

    @NonNls
    public String toString() {
        return "OptionTagBinding[" + this.myName + ", binding=" + this.myBinding + "]";
    }
}

