/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.text.CharSequenceBackedByArray;
import java.nio.CharBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharArrayUtil {
    public static void getChars(@NotNull CharSequence src, @NotNull char[] dst, int dstOffset) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.getChars must not be null");
        }
        if (dst == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.getChars must not be null");
        }
        CharArrayUtil.getChars(src, dst, dstOffset, src.length());
    }

    public static void getChars(@NotNull CharSequence src, @NotNull char[] dst, int dstOffset, int len) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.getChars must not be null");
        }
        if (dst == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.getChars must not be null");
        }
        CharArrayUtil.getChars(src, dst, 0, dstOffset, len);
    }

    public static void getChars(@NotNull CharSequence src, @NotNull char[] dst, int srcOffset, int dstOffset, int len) {
        if (src == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.getChars must not be null");
        }
        if (dst == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.getChars must not be null");
        }
        if (len >= 10) {
            if (src instanceof String) {
                ((String)src).getChars(srcOffset, len, dst, dstOffset);
                return;
            }
            if (src instanceof CharBuffer) {
                CharBuffer buffer = (CharBuffer)src;
                int i = buffer.position();
                buffer.position(i + srcOffset);
                buffer.get(dst, dstOffset, len);
                buffer.position(i);
                return;
            }
            if (src instanceof CharSequenceBackedByArray) {
                ((CharSequenceBackedByArray)src.subSequence(srcOffset, len)).getChars(dst, dstOffset);
                return;
            }
            if (src instanceof StringBuffer) {
                ((StringBuffer)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
                return;
            }
            if (src instanceof StringBuilder) {
                ((StringBuilder)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
                return;
            }
        }
        int i = 0;
        int max = srcOffset + len;
        for (int j = srcOffset; j < max && i < dst.length; ++i, ++j) {
            dst[i + dstOffset] = src.charAt(j);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static char[] fromSequenceStrict(@NotNull CharSequence seq) {
        char[] cArray;
        if (seq == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.fromSequenceStrict must not be null");
        }
        char[] chars = CharArrayUtil.fromSequence(seq);
        if (seq.length() == chars.length) {
            cArray = chars;
            if (chars == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/CharArrayUtil.fromSequenceStrict must not return null");
            return cArray;
        }
        char[] strictChars = new char[seq.length()];
        System.arraycopy(chars, 0, strictChars, 0, seq.length());
        cArray = strictChars;
        if (strictChars != null) return cArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/text/CharArrayUtil.fromSequenceStrict must not return null");
    }

    @Nullable
    public static char[] fromSequenceWithoutCopying(@Nullable CharSequence seq) {
        CharBuffer buffer;
        if (seq instanceof CharSequenceBackedByArray) {
            return ((CharSequenceBackedByArray)seq).getChars();
        }
        if (seq instanceof CharBuffer && (buffer = (CharBuffer)seq).hasArray() && !buffer.isReadOnly() && buffer.arrayOffset() == 0 && buffer.position() == 0) {
            return buffer.array();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static char[] fromSequence(@NotNull CharSequence seq) {
        char[] cArray;
        if (seq == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.fromSequence must not be null");
        }
        if (seq instanceof CharSequenceBackedByArray) {
            cArray = ((CharSequenceBackedByArray)seq).getChars();
            if (cArray == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/CharArrayUtil.fromSequence must not return null");
            return cArray;
        }
        if (seq instanceof CharBuffer) {
            CharBuffer buffer = (CharBuffer)seq;
            if (buffer.hasArray() && !buffer.isReadOnly() && buffer.arrayOffset() == 0) {
                cArray = buffer.array();
                if (cArray == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/CharArrayUtil.fromSequence must not return null");
                return cArray;
            } else {
                char[] chars = new char[seq.length()];
                buffer.position(0);
                buffer.get(chars);
                buffer.position(0);
                cArray = chars;
                if (chars == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/CharArrayUtil.fromSequence must not return null");
                return cArray;
            }
        }
        if (seq instanceof StringBuffer) {
            char[] chars = new char[seq.length()];
            ((StringBuffer)seq).getChars(0, seq.length(), chars, 0);
            cArray = chars;
            if (chars == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/CharArrayUtil.fromSequence must not return null");
            return cArray;
        }
        if (seq instanceof String) {
            char[] chars = new char[seq.length()];
            ((String)seq).getChars(0, seq.length(), chars, 0);
            cArray = chars;
            if (chars == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/CharArrayUtil.fromSequence must not return null");
            return cArray;
        }
        cArray = ((Object)seq).toString().toCharArray();
        if (cArray != null) return cArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/text/CharArrayUtil.fromSequence must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static char[] fromSequence(@NotNull CharSequence seq, int start, int end) {
        char[] cArray;
        if (seq == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.fromSequence must not be null");
        }
        if (seq instanceof CharSequenceBackedByArray) {
            cArray = Arrays.copyOfRange(((CharSequenceBackedByArray)seq).getChars(), start, end);
            if (cArray == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/CharArrayUtil.fromSequence must not return null");
            return cArray;
        }
        if (seq instanceof CharBuffer) {
            CharBuffer buffer = (CharBuffer)seq;
            char[] chars = new char[end - start];
            buffer.position(start);
            buffer.get(chars, 0, end - start);
            buffer.position(0);
            cArray = chars;
            if (chars == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/CharArrayUtil.fromSequence must not return null");
            return cArray;
        }
        if (seq instanceof StringBuffer) {
            char[] chars = new char[end - start];
            ((StringBuffer)seq).getChars(start, end, chars, 0);
            cArray = chars;
            if (chars == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/CharArrayUtil.fromSequence must not return null");
            return cArray;
        }
        String s = ((Object)seq).toString();
        char[] chars = new char[end - start];
        s.getChars(start, end, chars, 0);
        cArray = chars;
        if (chars != null) return cArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/text/CharArrayUtil.fromSequence must not return null");
    }

    public static int shiftForward(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.shiftForward must not be null");
        }
        if (chars == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.shiftForward must not be null");
        }
        return CharArrayUtil.shiftForward(buffer, offset, buffer.length(), chars);
    }

    public static int shiftForward(@NotNull CharSequence buffer, int startOffset, int endOffset, @NotNull String chars) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.shiftForward must not be null");
        }
        if (chars == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.shiftForward must not be null");
        }
        int limit = Math.min(endOffset, buffer.length());
        for (int offset = startOffset; offset < limit; ++offset) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i < chars.length()) continue;
            return offset;
        }
        return endOffset;
    }

    public static int shiftBackward(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.shiftBackward must not be null");
        }
        if (chars == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.shiftBackward must not be null");
        }
        return CharArrayUtil.shiftBackward(buffer, 0, offset, chars);
    }

    public static int shiftBackward(@NotNull CharSequence buffer, int minOffset, int maxOffset, @NotNull String chars) {
        int offset;
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.shiftBackward must not be null");
        }
        if (chars == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.shiftBackward must not be null");
        }
        if (maxOffset >= buffer.length()) {
            return maxOffset;
        }
        for (offset = maxOffset; offset >= minOffset; --offset) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i == chars.length()) break;
        }
        return offset;
    }

    public static int shiftBackwardUntil(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.shiftBackwardUntil must not be null");
        }
        if (chars == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.shiftBackwardUntil must not be null");
        }
        if (offset >= buffer.length()) {
            return offset;
        }
        while (offset >= 0) {
            int i;
            char c = buffer.charAt(offset);
            for (i = 0; i < chars.length() && c != chars.charAt(i); ++i) {
            }
            if (i < chars.length()) break;
            --offset;
        }
        return offset;
    }

    public static boolean regionMatches(@NotNull CharSequence buffer, int offset, @NotNull CharSequence s) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.regionMatches must not be null");
        }
        if (s == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.regionMatches must not be null");
        }
        if (offset + s.length() > buffer.length()) {
            return false;
        }
        if (offset < 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (buffer.charAt(offset + i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsOnlyWhiteSpaces(@Nullable CharSequence chars) {
        if (chars == null) {
            return true;
        }
        for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return false;
        }
        return true;
    }

    public static boolean containLineBreaks(@NotNull CharSequence seq) {
        if (seq == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/CharArrayUtil.containLineBreaks must not be null");
        }
        return CharArrayUtil.containLineBreaks(seq, 0, seq.length());
    }

    public static boolean containLineBreaks(@Nullable CharSequence seq, int fromOffset, int endOffset) {
        if (seq == null) {
            return false;
        }
        for (int i = fromOffset; i < endOffset; ++i) {
            char c = seq.charAt(i);
            if (c != '\n' && c != '\r') continue;
            return true;
        }
        return false;
    }
}

