/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentRefHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NotNull;

public final class ConcurrentSoftHashMap<K, V>
extends ConcurrentRefHashMap<K, V> {
    @Override
    protected ConcurrentRefHashMap.Key<K, V> createKey(@NotNull K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentSoftHashMap.createKey must not be null");
        }
        return new SoftKey(key, value, this.myReferenceQueue);
    }

    private static class SoftKey<K, V>
    extends SoftReference<K>
    implements ConcurrentRefHashMap.Key<K, V> {
        private final int myHash;
        private final V value;

        private SoftKey(@NotNull K k, V v, ReferenceQueue<K> q) {
            if (k == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentSoftHashMap$SoftKey.<init> must not be null");
            }
            super(k, q);
            this.value = v;
            this.myHash = k.hashCode();
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConcurrentRefHashMap.Key)) {
                return false;
            }
            Object t = this.get();
            Object u = ((ConcurrentRefHashMap.Key)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.myHash;
        }
    }
}

