/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class PatchedWeakReference<T>
extends WeakReference<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.PatchedWeakReference");
    private static List<PatchedWeakReference<?>> ourRefsList = new ArrayList();
    private static final ReferenceQueue ourQueue = new ReferenceQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchedWeakReference(T referent) {
        super(referent, ourQueue);
        ReferenceQueue referenceQueue = ourQueue;
        synchronized (referenceQueue) {
            ourRefsList.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processQueue() {
        PatchedWeakReference ref;
        boolean haveClearedRefs = false;
        while ((ref = (PatchedWeakReference)ourQueue.poll()) != null) {
            haveClearedRefs = true;
        }
        if (!haveClearedRefs) {
            return;
        }
        ReferenceQueue referenceQueue = ourQueue;
        synchronized (referenceQueue) {
            ArrayList newList = new ArrayList(ourRefsList.size() / 2 + 1);
            for (int i = 0; i < ourRefsList.size(); ++i) {
                PatchedWeakReference<?> ref2 = ourRefsList.get(i);
                if (ref2.get() == null) continue;
                newList.add(ref2);
            }
            if (LOG.isDebugEnabled()) {
                LOG.info("old size:" + ourRefsList.size());
                LOG.info("new size:" + newList.size());
            }
            ourRefsList = newList;
        }
    }

    static {
        JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                PatchedWeakReference.processQueue();
            }
        }, 500L, 500L, TimeUnit.MILLISECONDS);
    }
}

