/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.FileIconPatcher;
import com.intellij.ide.FileIconProvider;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.FileIconKey;
import com.intellij.util.NullableFunction;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconUtil {
    private static final Key<Boolean> PROJECT_WAS_EVER_INITIALIZED = Key.create("iconDeferrer:projectWasEverInitialized");

    private static boolean wasEverInitialized(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/IconUtil.wasEverInitialized must not be null");
        }
        Boolean was = project.getUserData(PROJECT_WAS_EVER_INITIALIZED);
        if (was == null) {
            if (project.isInitialized()) {
                was = true;
                project.putUserData(PROJECT_WAS_EVER_INITIALIZED, was);
            } else {
                was = false;
            }
        }
        return was;
    }

    public static Icon getIcon(@NotNull VirtualFile file, int flags, @Nullable Project project) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/IconUtil.getIcon must not be null");
        }
        Icon lastIcon = Iconable.LastComputedIcon.get(file, flags);
        Icon base = lastIcon != null ? lastIcon : VirtualFilePresentation.getIcon(file);
        return IconDeferrer.getInstance().defer(base, new FileIconKey(file, project, flags), new NullableFunction<FileIconKey, Icon>(){

            @Override
            public Icon fun(FileIconKey key) {
                VirtualFile file = key.getFile();
                int flags = key.getFlags();
                Project project = key.getProject();
                if (!file.isValid() || project != null && (project.isDisposed() || !IconUtil.wasEverInitialized(project))) {
                    return null;
                }
                Icon providersIcon = IconUtil.getProvidersIcon(file, flags, project);
                Icon icon = providersIcon == null ? VirtualFilePresentation.getIcon(file) : providersIcon;
                boolean dumb = project != null && DumbService.getInstance(project).isDumb();
                for (FileIconPatcher patcher : IconUtil.getPatchers()) {
                    if (dumb && !DumbService.isDumbAware(patcher)) continue;
                    icon = patcher.patchIcon(icon, file, flags, project);
                }
                if (!((flags & 2) == 0 || file.isWritable() && WritingAccessProvider.isPotentiallyWritable(file, project))) {
                    icon = new LayeredIcon(icon, PlatformIcons.LOCKED_ICON);
                }
                if (file.isSymLink()) {
                    icon = new LayeredIcon(icon, PlatformIcons.SYMLINK_ICON);
                }
                Iconable.LastComputedIcon.put(file, icon, flags);
                return icon;
            }
        });
    }

    @Nullable
    private static Icon getProvidersIcon(@NotNull VirtualFile file, int flags, Project project) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/IconUtil.getProvidersIcon must not be null");
        }
        for (FileIconProvider provider : IconUtil.getProviders()) {
            Icon icon = provider.getIcon(file, flags, project);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    private static FileIconProvider[] getProviders() {
        return FileIconProviderHolder.myProviders;
    }

    private static FileIconPatcher[] getPatchers() {
        return FileIconPatcherHolder.ourPatchers;
    }

    public static Icon getAddIcon() {
        return IconUtil.getToolbarDecoratorIcon("add.png");
    }

    public static Icon getRemoveIcon() {
        return IconUtil.getToolbarDecoratorIcon("remove.png");
    }

    public static Icon getEditIcon() {
        return IconUtil.getToolbarDecoratorIcon("edit.png");
    }

    public static Icon getAnalyzeIcon() {
        return IconUtil.getToolbarDecoratorIcon("analyze.png");
    }

    public static Icon getToolbarDecoratorIcon(String name) {
        return IconLoader.getIcon(IconUtil.getToolbarDecoratorIconsFolder() + name);
    }

    private static String getToolbarDecoratorIconsFolder() {
        return "/toolbarDecorator/" + (SystemInfo.isMac ? "mac/" : "");
    }

    private static class FileIconPatcherHolder {
        private static final FileIconPatcher[] ourPatchers = Extensions.getExtensions(FileIconPatcher.EP_NAME);
    }

    private static class FileIconProviderHolder {
        private static final FileIconProvider[] myProviders = Extensions.getExtensions(FileIconProvider.EP_NAME);
    }
}

