/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ExceptionUtil {
    @NotNull
    public static Throwable makeStackTraceRelative(@NotNull Throwable th, @NotNull Throwable relativeTo) {
        if (th == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ExceptionUtil.makeStackTraceRelative must not be null");
        }
        if (relativeTo == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ExceptionUtil.makeStackTraceRelative must not be null");
        }
        StackTraceElement[] trace = th.getStackTrace();
        StackTraceElement[] rootTrace = relativeTo.getStackTrace();
        int len = Math.min(trace.length, rootTrace.length);
        for (int i = 0; i < len; ++i) {
            if (trace[trace.length - i - 1].equals(rootTrace[rootTrace.length - i - 1])) continue;
            int newDepth = trace.length - i;
            th.setStackTrace(Arrays.asList(trace).subList(0, newDepth).toArray(new StackTraceElement[newDepth]));
            break;
        }
        Throwable throwable = th;
        if (throwable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ExceptionUtil.makeStackTraceRelative must not return null");
        }
        return throwable;
    }

    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable) {
        if (aThrowable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ExceptionUtil.getThrowableText must not be null");
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        aThrowable.printStackTrace(writer);
        String string = stringWriter.getBuffer().toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ExceptionUtil.getThrowableText must not return null");
        }
        return string;
    }
}

