/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiUtilCore {
    public static final PsiElement NULL_PSI_ELEMENT = new PsiElement(){

        @Override
        @NotNull
        public Project getProject() {
            throw this.createException();
        }

        @Override
        @NotNull
        public Language getLanguage() {
            throw this.createException();
        }

        @Override
        public PsiManager getManager() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiElement[] getChildren() {
            throw this.createException();
        }

        @Override
        public PsiElement getParent() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getFirstChild() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getLastChild() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getNextSibling() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getPrevSibling() {
            throw this.createException();
        }

        @Override
        public PsiFile getContainingFile() {
            throw this.createException();
        }

        @Override
        public TextRange getTextRange() {
            throw this.createException();
        }

        @Override
        public int getStartOffsetInParent() {
            throw this.createException();
        }

        @Override
        public int getTextLength() {
            throw this.createException();
        }

        @Override
        public PsiElement findElementAt(int offset) {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiReference findReferenceAt(int offset) {
            throw this.createException();
        }

        @Override
        public int getTextOffset() {
            throw this.createException();
        }

        @Override
        public String getText() {
            throw this.createException();
        }

        @Override
        @NotNull
        public char[] textToCharArray() {
            throw this.createException();
        }

        @Override
        public PsiElement getNavigationElement() {
            throw this.createException();
        }

        @Override
        public PsiElement getOriginalElement() {
            throw this.createException();
        }

        @Override
        public boolean textMatches(@NotNull CharSequence text) {
            if (text == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilCore$1.textMatches must not be null");
            }
            throw this.createException();
        }

        @Override
        public boolean textMatches(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilCore$1.textMatches must not be null");
            }
            throw this.createException();
        }

        @Override
        public boolean textContains(char c) {
            throw this.createException();
        }

        @Override
        public void accept(@NotNull PsiElementVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilCore$1.accept must not be null");
            }
            throw this.createException();
        }

        @Override
        public void acceptChildren(@NotNull PsiElementVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilCore$1.acceptChildren must not be null");
            }
            throw this.createException();
        }

        @Override
        public PsiElement copy() {
            throw this.createException();
        }

        @Override
        public PsiElement add(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilCore$1.add must not be null");
            }
            throw this.createException();
        }

        @Override
        public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilCore$1.addBefore must not be null");
            }
            throw this.createException();
        }

        @Override
        public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilCore$1.addAfter must not be null");
            }
            throw this.createException();
        }

        @Override
        public void checkAdd(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilCore$1.checkAdd must not be null");
            }
            throw this.createException();
        }

        @Override
        public PsiElement addRange(PsiElement first, PsiElement last) {
            throw this.createException();
        }

        @Override
        public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) {
            if (first == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilCore$1.addRangeBefore must not be null");
            }
            if (last == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiUtilCore$1.addRangeBefore must not be null");
            }
            throw this.createException();
        }

        @Override
        public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) {
            throw this.createException();
        }

        @Override
        public void delete() {
            throw this.createException();
        }

        @Override
        public void checkDelete() {
            throw this.createException();
        }

        @Override
        public void deleteChildRange(PsiElement first, PsiElement last) {
            throw this.createException();
        }

        @Override
        public PsiElement replace(@NotNull PsiElement newElement) {
            if (newElement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilCore$1.replace must not be null");
            }
            throw this.createException();
        }

        @Override
        public boolean isValid() {
            throw this.createException();
        }

        @Override
        public boolean isWritable() {
            throw this.createException();
        }

        private PsiInvalidElementAccessException createException() {
            return new PsiInvalidElementAccessException(this, "NULL_PSI_ELEMENT", null);
        }

        @Override
        @Nullable
        public PsiReference getReference() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiReference[] getReferences() {
            throw this.createException();
        }

        @Override
        public <T> T getCopyableUserData(Key<T> key) {
            throw this.createException();
        }

        @Override
        public <T> void putCopyableUserData(Key<T> key, T value) {
            throw this.createException();
        }

        @Override
        public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
            if (processor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilCore$1.processDeclarations must not be null");
            }
            if (state == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiUtilCore$1.processDeclarations must not be null");
            }
            if (place == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/util/PsiUtilCore$1.processDeclarations must not be null");
            }
            throw this.createException();
        }

        @Override
        public PsiElement getContext() {
            throw this.createException();
        }

        @Override
        public boolean isPhysical() {
            throw this.createException();
        }

        @Override
        @NotNull
        public GlobalSearchScope getResolveScope() {
            throw this.createException();
        }

        @Override
        @NotNull
        public SearchScope getUseScope() {
            throw this.createException();
        }

        @Override
        public ASTNode getNode() {
            throw this.createException();
        }

        @Override
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilCore$1.getUserData must not be null");
            }
            throw this.createException();
        }

        @Override
        public <T> void putUserData(@NotNull Key<T> key, T value) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilCore$1.putUserData must not be null");
            }
            throw this.createException();
        }

        @Override
        public Icon getIcon(int flags) {
            throw this.createException();
        }

        @Override
        public boolean isEquivalentTo(PsiElement another) {
            return this == another;
        }

        @Override
        public String toString() {
            return "NULL_PSI_ELEMENT";
        }
    };

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiElement[] toPsiElementArray(@NotNull Collection<? extends PsiElement> collection) {
        PsiElement[] psiElementArray;
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilCore.toPsiElementArray must not be null");
        }
        if (collection.isEmpty()) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtilCore.toPsiElementArray must not return null");
            return psiElementArray;
        }
        psiElementArray = collection.toArray(new PsiElement[collection.size()]);
        if (psiElementArray != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtilCore.toPsiElementArray must not return null");
    }

    public static Language getNotAnyLanguage(ASTNode node) {
        if (node == null) {
            return Language.ANY;
        }
        Language lang = node.getElementType().getLanguage();
        return lang == Language.ANY ? PsiUtilCore.getNotAnyLanguage(node.getTreeParent()) : lang;
    }

    @Nullable
    public static VirtualFile getVirtualFile(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        if (element instanceof PsiFileSystemItem) {
            return ((PsiFileSystemItem)element).getVirtualFile();
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        return containingFile.getVirtualFile();
    }

    public static int compareElementsByPosition(PsiElement element1, PsiElement element2) {
        if (element1 != null && element2 != null) {
            PsiFile psiFile2;
            PsiFile psiFile1 = element1.getContainingFile();
            if (Comparing.equal(psiFile1, psiFile2 = element2.getContainingFile())) {
                TextRange textRange1 = element1.getTextRange();
                TextRange textRange2 = element2.getTextRange();
                if (textRange1 != null && textRange2 != null) {
                    return textRange1.getStartOffset() - textRange2.getStartOffset();
                }
            } else if (psiFile1 != null && psiFile2 != null) {
                String name1 = psiFile1.getName();
                String name2 = psiFile2.getName();
                return name1.compareToIgnoreCase(name2);
            }
        }
        return 0;
    }

    public static boolean hasErrorElementChild(PsiElement element) {
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiElement getElementAtOffset(@NotNull PsiFile file, int offset) {
        PsiElement psiElement;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilCore.getElementAtOffset must not be null");
        }
        PsiElement elt = file.findElementAt(offset);
        if (elt == null && offset > 0) {
            elt = file.findElementAt(offset - 1);
        }
        if (elt == null) {
            psiElement = file;
            if (psiElement == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtilCore.getElementAtOffset must not return null");
            return psiElement;
        }
        psiElement = elt;
        if (psiElement != null) return psiElement;
        throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtilCore.getElementAtOffset must not return null");
    }

    @Nullable
    public static PsiFile getTemplateLanguageFile(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiFile[] toPsiFileArray(@NotNull Collection<? extends PsiFile> collection) {
        PsiFile[] psiFileArray;
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilCore.toPsiFileArray must not be null");
        }
        if (collection.isEmpty()) {
            psiFileArray = PsiFile.EMPTY_ARRAY;
            if (PsiFile.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtilCore.toPsiFileArray must not return null");
            return psiFileArray;
        }
        psiFileArray = collection.toArray(new PsiFile[collection.size()]);
        if (psiFileArray != null) return psiFileArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtilCore.toPsiFileArray must not return null");
    }

    @Nullable
    public static String getName(PsiElement element) {
        PsiMetaData data;
        String name = null;
        if (element instanceof PsiMetaOwner && (data = ((PsiMetaOwner)((Object)element)).getMetaData()) != null) {
            name = data.getName(element);
        }
        if (name == null && element instanceof PsiNamedElement) {
            name = ((PsiNamedElement)element).getName();
        }
        return name;
    }

    public static String getQualifiedNameAfterRename(String qName, String newName) {
        if (qName == null) {
            return newName;
        }
        int index = qName.lastIndexOf(46);
        return index < 0 ? newName : qName.substring(0, index + 1) + newName;
    }
}

