/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypesUtil {
    @NonNls
    private static final Map<String, String> ourUnboxedTypes = new THashMap<String, String>();
    @NonNls
    private static final Map<String, String> ourBoxedTypes = new THashMap<String, String>();

    private PsiTypesUtil() {
    }

    public static String getDefaultValueOfType(PsiType type) {
        if (type instanceof PsiArrayType) {
            PsiClassType classType;
            int count = type.getArrayDimensions() - 1;
            PsiType componentType = type.getDeepComponentType();
            if (componentType instanceof PsiClassType && (classType = (PsiClassType)componentType).resolve() instanceof PsiTypeParameter) {
                return "null";
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append("new");
            buffer.append(" ");
            buffer.append(componentType.getCanonicalText());
            buffer.append("[0]");
            for (int i = 0; i < count; ++i) {
                buffer.append("[]");
            }
            return buffer.toString();
        }
        if (type instanceof PsiPrimitiveType) {
            if (PsiType.BOOLEAN.equals(type)) {
                return "false";
            }
            return "0";
        }
        return "null";
    }

    @Nullable
    public static String unboxIfPossible(String type) {
        if (type == null) {
            return null;
        }
        String s = ourUnboxedTypes.get(type);
        return s == null ? type : s;
    }

    @Nullable
    public static String boxIfPossible(String type) {
        if (type == null) {
            return null;
        }
        String s = ourBoxedTypes.get(type);
        return s == null ? type : s;
    }

    @Nullable
    public static PsiClass getPsiClass(PsiType psiType) {
        return psiType instanceof PsiClassType ? ((PsiClassType)psiType).resolve() : null;
    }

    public static PsiClassType getClassType(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTypesUtil.getClassType must not be null");
        }
        return JavaPsiFacade.getElementFactory(psiClass.getProject()).createType(psiClass);
    }

    @Nullable
    public static PsiClassType getLowestUpperBoundClassType(@NotNull PsiDisjunctionType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTypesUtil.getLowestUpperBoundClassType must not be null");
        }
        PsiType lub = type.getLeastUpperBound();
        if (lub instanceof PsiClassType) {
            return (PsiClassType)lub;
        }
        if (lub instanceof PsiIntersectionType) {
            for (PsiType subType : ((PsiIntersectionType)lub).getConjuncts()) {
                PsiClass aClass;
                if (!(subType instanceof PsiClassType) || (aClass = ((PsiClassType)subType).resolve()) == null || aClass.isInterface()) continue;
                return (PsiClassType)subType;
            }
        }
        return null;
    }

    public static PsiType patchMethodGetClassReturnType(@NotNull PsiExpression call, @NotNull PsiReferenceExpression methodExpression, @NotNull PsiMethod method, @Nullable Condition<IElementType> condition, @NotNull LanguageLevel languageLevel) {
        if (call == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTypesUtil.patchMethodGetClassReturnType must not be null");
        }
        if (methodExpression == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTypesUtil.patchMethodGetClassReturnType must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/util/PsiTypesUtil.patchMethodGetClassReturnType must not be null");
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/psi/util/PsiTypesUtil.patchMethodGetClassReturnType must not be null");
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5) && "getClass".equals(method.getName()) && "java.lang.Object".equals(method.getContainingClass().getQualifiedName())) {
            PsiClass javaLangClass;
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiType qualifierType = null;
            Project project = call.getProject();
            if (qualifier != null) {
                qualifierType = TypeConversionUtil.erasure(qualifier.getType());
            } else if (condition != null) {
                ASTNode parent;
                for (parent = call.getNode().getTreeParent(); parent != null && condition.value(parent.getElementType()); parent = parent.getTreeParent()) {
                }
                if (parent != null) {
                    qualifierType = JavaPsiFacade.getInstance(project).getElementFactory().createType((PsiClass)parent.getPsi());
                }
            }
            if (qualifierType != null && (javaLangClass = JavaPsiFacade.getInstance(project).findClass("java.lang.Class", call.getResolveScope())) != null && javaLangClass.getTypeParameters().length == 1) {
                HashMap<PsiTypeParameter, PsiType> map = new HashMap<PsiTypeParameter, PsiType>();
                map.put(javaLangClass.getTypeParameters()[0], PsiWildcardType.createExtends(call.getManager(), qualifierType));
                PsiSubstitutor substitutor = JavaPsiFacade.getInstance(project).getElementFactory().createSubstitutor(map);
                PsiClassType classType = JavaPsiFacade.getInstance(project).getElementFactory().createType(javaLangClass, substitutor, languageLevel);
                PsiElement parent = call.getParent();
                return parent instanceof PsiReferenceExpression && parent.getParent() instanceof PsiMethodCallExpression ? PsiUtil.captureToplevelWildcards(classType, methodExpression) : classType;
            }
        }
        return null;
    }

    static {
        ourUnboxedTypes.put("java.lang.Boolean", "boolean");
        ourUnboxedTypes.put("java.lang.Byte", "byte");
        ourUnboxedTypes.put("java.lang.Short", "short");
        ourUnboxedTypes.put("java.lang.Integer", "int");
        ourUnboxedTypes.put("java.lang.Long", "long");
        ourUnboxedTypes.put("java.lang.Float", "float");
        ourUnboxedTypes.put("java.lang.Double", "double");
        ourUnboxedTypes.put("java.lang.Character", "char");
        ourBoxedTypes.put("boolean", "java.lang.Boolean");
        ourBoxedTypes.put("byte", "java.lang.Byte");
        ourBoxedTypes.put("short", "java.lang.Short");
        ourBoxedTypes.put("int", "java.lang.Integer");
        ourBoxedTypes.put("long", "java.lang.Long");
        ourBoxedTypes.put("float", "java.lang.Float");
        ourBoxedTypes.put("double", "java.lang.Double");
        ourBoxedTypes.put("char", "java.lang.Character");
    }
}

