/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public interface CachedValueProvider<T> {
    @Nullable
    public Result<T> compute();

    public static class Result<T> {
        private final T myValue;
        private final Object[] myDependencyItems;

        public Result(@Nullable T value, Object ... dependencyItems) {
            this.myValue = value;
            this.myDependencyItems = dependencyItems;
        }

        public T getValue() {
            return this.myValue;
        }

        public Object[] getDependencyItems() {
            return this.myDependencyItems;
        }

        public static <T> Result<T> createSingleDependency(@Nullable T value, Object dependency) {
            return Result.create(value, dependency);
        }

        public static <T> Result<T> create(@Nullable T value, Object ... dependencies) {
            return new Result<T>(value, dependencies);
        }

        public static <T> Result<T> create(@Nullable T value, Collection<?> dependencies) {
            return new Result<T>(value, ArrayUtil.toObjectArray(dependencies));
        }

        @Deprecated
        public void setLockValue(boolean lockValue) {
        }
    }
}

