/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.LightStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.annotations.NonNls;

public class ILightStubFileElementType<T extends PsiFileStub>
extends IStubFileElementType<T> {
    public ILightStubFileElementType(Language language) {
        super(language);
    }

    public ILightStubFileElementType(@NonNls String debugName, Language language) {
        super(debugName, language);
    }

    @Override
    public LightStubBuilder getBuilder() {
        return new LightStubBuilder();
    }

    public FlyweightCapableTreeStructure<LighterASTNode> parseContentsLight(ASTNode chameleon) {
        PsiElement psi = chameleon.getPsi();
        assert (psi != null) : "Bad chameleon: " + chameleon;
        Project project = psi.getProject();
        PsiBuilderFactory factory = PsiBuilderFactory.getInstance();
        PsiBuilder builder = factory.createBuilder(project, chameleon);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.getLanguage());
        assert (parserDefinition != null) : this;
        PsiParser parser = parserDefinition.createParser(project);
        parser.parse(this, builder);
        return builder.getLightTree();
    }
}

