/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.SubstitutedFileType;
import org.jetbrains.annotations.Nullable;

public class StubTreeBuilder {
    private static final Key<Stub> stubElementKey = Key.create("stub.tree.for.file.content");

    private StubTreeBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Stub buildStubTree(FileContent inputData) {
        Stub data = inputData.getUserData(stubElementKey);
        if (data != null) {
            return data;
        }
        FileContent fileContent = inputData;
        synchronized (fileContent) {
            data = inputData.getUserData(stubElementKey);
            if (data != null) {
                return data;
            }
            FileType fileType = inputData.getFileType();
            BinaryFileStubBuilder builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType);
            if (builder != null) {
                data = builder.buildStubTree(inputData.getFile(), inputData.getContent(), inputData.getProject());
            } else if (!fileType.isBinary()) {
                LanguageFileType languageFileType = (LanguageFileType)fileType;
                Language l = languageFileType.getLanguage();
                IFileElementType type = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l)).getFileNodeType();
                PsiFile psi = inputData.getPsiFile();
                CharSequence contentAsText = inputData.getContentAsText();
                psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, contentAsText);
                try {
                    SubstitutedFileType substituted;
                    LanguageFileType original;
                    IFileElementType originalType;
                    if (type instanceof IStubFileElementType) {
                        data = ((IStubFileElementType)type).getBuilder().buildStubTree(psi);
                    } else if (languageFileType instanceof SubstitutedFileType && (originalType = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((original = (LanguageFileType)(substituted = (SubstitutedFileType)languageFileType).getOriginalFileType()).getLanguage())).getFileNodeType()) instanceof IStubFileElementType) {
                        data = ((IStubFileElementType)originalType).getBuilder().buildStubTree(psi);
                    }
                }
                finally {
                    psi.putUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY, null);
                }
            }
            inputData.putUserData(stubElementKey, data);
            return data;
        }
    }
}

