/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.processor;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.ResolveState;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;

public class MethodResolverProcessor
extends MethodCandidatesProcessor {
    private boolean myStopAcceptingCandidates;

    public MethodResolverProcessor(@NotNull PsiMethodCallExpression place) {
        if (place == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/scope/processor/MethodResolverProcessor.<init> must not be null");
        }
        this(place, new PsiConflictResolver[]{new JavaMethodsConflictResolver(place.getArgumentList())});
        this.setArgumentList(place.getArgumentList());
        this.obtainTypeArguments(place);
    }

    public MethodResolverProcessor(PsiClass classConstr, @NotNull PsiExpressionList argumentList, @NotNull PsiElement place) {
        if (argumentList == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/scope/processor/MethodResolverProcessor.<init> must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/scope/processor/MethodResolverProcessor.<init> must not be null");
        }
        super(place, new PsiConflictResolver[]{new JavaMethodsConflictResolver(argumentList)}, new SmartList<CandidateInfo>());
        this.myStopAcceptingCandidates = false;
        this.setIsConstructor(true);
        this.setAccessClass(classConstr);
        this.setArgumentList(argumentList);
    }

    public MethodResolverProcessor(@NotNull PsiElement place, @NotNull PsiConflictResolver[] resolvers) {
        if (place == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/scope/processor/MethodResolverProcessor.<init> must not be null");
        }
        if (resolvers == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/scope/processor/MethodResolverProcessor.<init> must not be null");
        }
        super(place, resolvers, new SmartList<CandidateInfo>());
        this.myStopAcceptingCandidates = false;
    }

    @Override
    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        if (event == JavaScopeProcessorEvent.CHANGE_LEVEL && this.myHasAccessibleStaticCorrectCandidate) {
            this.myStopAcceptingCandidates = true;
        }
        super.handleEvent(event, associated);
    }

    @Override
    public boolean execute(@NotNull PsiElement element, ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/scope/processor/MethodResolverProcessor.execute must not be null");
        }
        return !this.myStopAcceptingCandidates && super.execute(element, state);
    }
}

