/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class PsiExpressionListImpl
extends CompositePsiElement
implements PsiExpressionList {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiExpressionListImpl");

    public PsiExpressionListImpl() {
        super(JavaElementType.EXPRESSION_LIST);
    }

    @Override
    @NotNull
    public PsiExpression[] getExpressions() {
        PsiExpression[] psiExpressionArray = (PsiExpression[])this.getChildrenAsPsiElements(ElementType.EXPRESSION_BIT_SET, PsiExpression.ARRAY_FACTORY);
        if (psiExpressionArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiExpressionListImpl.getExpressions must not return null");
        }
        return psiExpressionArray;
    }

    @Override
    @NotNull
    public PsiType[] getExpressionTypes() {
        PsiExpression[] expressions = this.getExpressions();
        PsiType[] types = new PsiType[expressions.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = expressions[i].getType();
        }
        if (types == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiExpressionListImpl.getExpressionTypes must not return null");
        }
        return types;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 24: {
                return this.getFirstChildNode() != null && this.getFirstChildNode().getElementType() == JavaTokenType.LPARENTH ? this.getFirstChildNode() : null;
            }
            case 25: 
        }
        if (this.getLastChildNode() != null && this.getLastChildNode().getElementType() == JavaTokenType.RPARENTH) {
            return this.getLastChildNode();
        }
        return null;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.COMMA) {
            return 23;
        }
        if (i == JavaTokenType.LPARENTH) {
            return 24;
        }
        if (i == JavaTokenType.RPARENTH) {
            return 25;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 59;
        }
        return 0;
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
        if (anchor == null) {
            LeafElement rparenth;
            LeafElement lparenth;
            if (before == null || before.booleanValue()) {
                anchor = this.findChildByRole(25);
                if (anchor == null) {
                    lparenth = Factory.createSingleLeafElement(JavaTokenType.LPARENTH, "(", 0, 1, treeCharTab, this.getManager());
                    super.addInternal(lparenth, lparenth, null, Boolean.FALSE);
                    rparenth = Factory.createSingleLeafElement(JavaTokenType.RPARENTH, ")", 0, 1, treeCharTab, this.getManager());
                    super.addInternal(rparenth, rparenth, null, Boolean.TRUE);
                    anchor = this.findChildByRole(25);
                    LOG.assertTrue(anchor != null);
                }
                before = Boolean.TRUE;
            } else {
                anchor = this.findChildByRole(24);
                if (anchor == null) {
                    lparenth = Factory.createSingleLeafElement(JavaTokenType.LPARENTH, "(", 0, 1, treeCharTab, this.getManager());
                    super.addInternal(lparenth, lparenth, null, Boolean.FALSE);
                    rparenth = Factory.createSingleLeafElement(JavaTokenType.RPARENTH, ")", 0, 1, treeCharTab, this.getManager());
                    super.addInternal(rparenth, rparenth, null, Boolean.TRUE);
                    anchor = this.findChildByRole(24);
                    LOG.assertTrue(anchor != null);
                }
                before = Boolean.FALSE;
            }
        }
        TreeElement firstAdded = super.addInternal(first, last, anchor, before);
        if (ElementType.EXPRESSION_BIT_SET.contains(first.getElementType())) {
            IElementType t;
            ASTNode child;
            TreeElement element = first;
            for (child = element.getTreeNext(); child != null && child.getElementType() != JavaTokenType.COMMA; child = child.getTreeNext()) {
                if (!ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) continue;
                LeafElement comma = Factory.createSingleLeafElement(JavaTokenType.COMMA, ",", 0, 1, treeCharTab, this.getManager());
                super.addInternal(comma, comma, element, Boolean.FALSE);
                break;
            }
            for (child = element.getTreePrev(); child != null && (t = child.getElementType()) != JavaTokenType.COMMA; child = child.getTreePrev()) {
                if (!ElementType.EXPRESSION_BIT_SET.contains(t) && !ElementType.JAVA_COMMENT_BIT_SET.contains(t)) continue;
                LeafElement comma = Factory.createSingleLeafElement(JavaTokenType.COMMA, ",", 0, 1, treeCharTab, this.getManager());
                super.addInternal(comma, comma, child, Boolean.FALSE);
                break;
            }
        }
        return firstAdded;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiExpressionListImpl.deleteChildInternal must not be null");
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            ASTNode next = PsiImplUtil.skipWhitespaceAndComments(child.getTreeNext());
            if (next != null && next.getElementType() == JavaTokenType.COMMA) {
                this.deleteChildInternal(next);
            } else {
                ASTNode prev = PsiImplUtil.skipWhitespaceAndCommentsBack(child.getTreePrev());
                if (prev != null && prev.getElementType() == JavaTokenType.COMMA) {
                    this.deleteChildInternal(prev);
                }
            }
        }
        super.deleteChildInternal(child);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiExpressionListImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitExpressionList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiExpressionList";
    }
}

