/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiLabelReference;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiBreakStatementImpl
extends CompositePsiElement
implements PsiBreakStatement,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiBreakStatementImpl");

    public PsiBreakStatementImpl() {
        super(BREAK_STATEMENT);
    }

    @Override
    public PsiIdentifier getLabelIdentifier() {
        return (PsiIdentifier)this.findChildByRoleAsPsiElement(83);
    }

    @Override
    public PsiStatement findExitedStatement() {
        PsiIdentifier label = this.getLabelIdentifier();
        if (label == null) {
            for (ASTNode parent = this.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
                IElementType i = parent.getElementType();
                if (i == FOR_STATEMENT || i == WHILE_STATEMENT || i == DO_WHILE_STATEMENT || i == SWITCH_STATEMENT || i == FOREACH_STATEMENT) {
                    return (PsiStatement)SourceTreeToPsiMap.treeElementToPsi(parent);
                }
                if (i != METHOD && i != CLASS_INITIALIZER) continue;
                return null;
            }
        } else {
            String labelName = label.getText();
            for (CompositeElement parent = this.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
                ASTNode statementLabel;
                if (parent.getElementType() == LABELED_STATEMENT && (statementLabel = parent.findChildByRole(93)).getText().equals(labelName)) {
                    return ((PsiLabeledStatement)SourceTreeToPsiMap.treeElementToPsi(parent)).getStatement();
                }
                if (parent.getElementType() != METHOD && parent.getElementType() != CLASS_INITIALIZER) continue;
                return null;
            }
        }
        return null;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 81: {
                return this.findChildByType(BREAK_KEYWORD);
            }
            case 83: {
                return this.findChildByType(IDENTIFIER);
            }
            case 22: 
        }
        return TreeUtil.findChildBackward(this, SEMICOLON);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == BREAK_KEYWORD) {
            return 81;
        }
        if (i == IDENTIFIER) {
            return 83;
        }
        if (i == SEMICOLON) {
            return 22;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiBreakStatementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitBreakStatement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        if (references != null && references.length > 0) {
            return references[0];
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray;
        if (this.getLabelIdentifier() == null) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiBreakStatementImpl.getReferences must not return null");
            return psiReferenceArray;
        }
        psiReferenceArray = new PsiReference[]{new PsiLabelReference(this, this.getLabelIdentifier())};
        if (psiReferenceArray != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiBreakStatementImpl.getReferences must not return null");
    }

    @Override
    public String toString() {
        return "PsiBreakStatement";
    }
}

