/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.WalkingState;
import org.jetbrains.annotations.NotNull;

public abstract class RecursiveTreeElementWalkingVisitor
extends TreeElementVisitor {
    private final boolean myDoTransform;
    private final WalkingState<ASTNode> myWalkingState = new WalkingState<ASTNode>((WalkingState.TreeGuide)ASTTreeGuide.access$000()){

        @Override
        public void elementFinished(@NotNull ASTNode element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/RecursiveTreeElementWalkingVisitor$1.elementFinished must not be null");
            }
        }

        @Override
        public void visit(@NotNull ASTNode element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/RecursiveTreeElementWalkingVisitor$1.visit must not be null");
            }
            ((TreeElement)element).acceptTree(RecursiveTreeElementWalkingVisitor.this);
        }
    };

    protected RecursiveTreeElementWalkingVisitor() {
        this(true);
    }

    protected RecursiveTreeElementWalkingVisitor(boolean doTransform) {
        this.myDoTransform = doTransform;
    }

    @Override
    public void visitLeaf(LeafElement leaf) {
        this.visitNode(leaf);
    }

    @Override
    public void visitComposite(CompositeElement composite) {
        this.visitNode(composite);
    }

    protected void visitNode(TreeElement element) {
        if (this.myDoTransform || !TreeUtil.isCollapsedChameleon(element)) {
            this.myWalkingState.elementStarted(element);
        }
    }

    public void stopWalking() {
        this.myWalkingState.stopWalking();
    }

    private static class ASTTreeGuide
    implements WalkingState.TreeGuide<ASTNode> {
        private static final ASTTreeGuide instance = new ASTTreeGuide();

        private ASTTreeGuide() {
        }

        @Override
        public ASTNode getNextSibling(@NotNull ASTNode element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/RecursiveTreeElementWalkingVisitor$ASTTreeGuide.getNextSibling must not be null");
            }
            return element.getTreeNext();
        }

        @Override
        public ASTNode getPrevSibling(@NotNull ASTNode element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/RecursiveTreeElementWalkingVisitor$ASTTreeGuide.getPrevSibling must not be null");
            }
            return element.getTreePrev();
        }

        @Override
        public ASTNode getFirstChild(@NotNull ASTNode element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/RecursiveTreeElementWalkingVisitor$ASTTreeGuide.getFirstChild must not be null");
            }
            return element.getFirstChildNode();
        }

        @Override
        public ASTNode getParent(@NotNull ASTNode element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/RecursiveTreeElementWalkingVisitor$ASTTreeGuide.getParent must not be null");
            }
            return element.getTreeParent();
        }

        static /* synthetic */ ASTTreeGuide access$000() {
            return instance;
        }
    }
}

