/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.annotations.NotNull;

public class PsiReferenceListImpl
extends JavaStubPsiElement<PsiClassReferenceListStub>
implements PsiReferenceList {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiReferenceListImpl");

    public PsiReferenceListImpl(PsiClassReferenceListStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public PsiReferenceListImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement[] getReferenceElements() {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = (PsiJavaCodeReferenceElement[])this.calcTreeElement().getChildrenAsPsiElements(JavaElementType.JAVA_CODE_REFERENCE, PsiJavaCodeReferenceElement.ARRAY_FACTORY);
        if (psiJavaCodeReferenceElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiReferenceListImpl.getReferenceElements must not return null");
        }
        return psiJavaCodeReferenceElementArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiClassType[] getReferencedTypes() {
        PsiClassType[] psiClassTypeArray;
        PsiClassReferenceListStub stub = (PsiClassReferenceListStub)this.getStub();
        if (stub != null) {
            psiClassTypeArray = stub.getReferencedTypes();
            if (psiClassTypeArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiReferenceListImpl.getReferencedTypes must not return null");
            return psiClassTypeArray;
        }
        PsiJavaCodeReferenceElement[] refs = this.getReferenceElements();
        PsiElementFactory factory = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
        PsiClassType[] types = new PsiClassType[refs.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = factory.createType(refs[i]);
        }
        psiClassTypeArray = types;
        if (types != null) return psiClassTypeArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiReferenceListImpl.getReferencedTypes must not return null");
    }

    @Override
    public PsiReferenceList.Role getRole() {
        IStubElementType type = this.getElementType();
        if (type == JavaElementType.EXTENDS_LIST) {
            return PsiReferenceList.Role.EXTENDS_LIST;
        }
        if (type == JavaElementType.IMPLEMENTS_LIST) {
            return PsiReferenceList.Role.IMPLEMENTS_LIST;
        }
        if (type == JavaElementType.THROWS_LIST) {
            return PsiReferenceList.Role.THROWS_LIST;
        }
        if (type == JavaElementType.EXTENDS_BOUND_LIST) {
            return PsiReferenceList.Role.EXTENDS_BOUNDS_LIST;
        }
        LOG.error("Unknown element type:" + type);
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiReferenceListImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return this.getElementType() == JavaElementType.EXTENDS_BOUND_LIST ? "PsiElement(EXTENDS_BOUND_LIST)" : "PsiReferenceList";
    }
}

