/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class LightKeyword
extends LightElement
implements PsiJavaToken,
PsiKeyword {
    private final String myText;

    public LightKeyword(PsiManager manager, String text) {
        super(manager, JavaLanguage.INSTANCE);
        this.myText = text;
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public IElementType getTokenType() {
        JavaLexer lexer = new JavaLexer(LanguageLevel.HIGHEST);
        lexer.start(this.myText);
        return ((Lexer)lexer).getTokenType();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightKeyword.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitKeyword(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiElement copy() {
        return new LightKeyword(this.getManager(), this.myText);
    }

    @Override
    public String toString() {
        return "PsiKeyword:" + this.getText();
    }
}

