/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.java.stubs.impl.PsiAnnotationParameterListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiNameValuePairStubImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.io.StringRef;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PsiAnnotationStubImpl
extends StubBase<PsiAnnotation>
implements PsiAnnotationStub {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl");
    private final String myText;
    private SoftReference<PsiAnnotation> myParsedFromRepository;

    public PsiAnnotationStubImpl(StubElement parent, String text) {
        this(parent, text, null);
    }

    public PsiAnnotationStubImpl(StubElement parent, String text, @Nullable List<Pair<String, String>> attributes) {
        super(parent, JavaStubElementTypes.ANNOTATION);
        this.myText = text;
        if (attributes != null) {
            PsiAnnotationParameterListStubImpl list = new PsiAnnotationParameterListStubImpl(this);
            for (Pair<String, String> attribute : attributes) {
                new PsiNameValuePairStubImpl(list, StringRef.fromString((String)attribute.first), StringRef.fromString((String)attribute.second));
            }
        }
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public PsiAnnotation getPsiElement() {
        PsiAnnotation annotation;
        if (this.myParsedFromRepository != null && (annotation = (PsiAnnotation)this.myParsedFromRepository.get()) != null) {
            return annotation;
        }
        String text = this.getText();
        try {
            PsiJavaParserFacade facade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
            PsiAnnotation annotation2 = facade.createAnnotationFromText(text, (PsiElement)this.getPsi());
            this.myParsedFromRepository = new SoftReference<PsiAnnotation>(annotation2);
            return annotation2;
        }
        catch (IncorrectOperationException e) {
            LOG.error("Bad annotation in repository!", e);
            return null;
        }
    }

    @Override
    public String toString() {
        return "PsiAnnotationStub[" + this.myText + "]";
    }
}

