/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.RowIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiPackageBase
extends PsiElementBase
implements Queryable,
PsiDirectoryContainer {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.file.PsiPackageBase");
    final PsiManager myManager;
    private final String myQualifiedName;

    protected abstract Collection<PsiDirectory> getAllDirectories();

    protected abstract PsiElement findPackage(String var1);

    protected abstract PsiPackageBase createInstance(PsiManager var1, String var2);

    public PsiPackageBase(PsiManager manager, String qualifiedName) {
        this.myManager = manager;
        this.myQualifiedName = qualifiedName;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && this.myManager == ((PsiPackageBase)o).myManager && this.myQualifiedName.equals(((PsiPackageBase)o).myQualifiedName);
    }

    public int hashCode() {
        return this.myQualifiedName.hashCode();
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myQualifiedName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageBase.getQualifiedName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public PsiDirectory[] getDirectories() {
        Collection<PsiDirectory> collection = this.getAllDirectories();
        PsiDirectory[] psiDirectoryArray = ContainerUtil.toArray(collection, new PsiDirectory[collection.size()]);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageBase.getDirectories must not return null");
        }
        return psiDirectoryArray;
    }

    @Override
    @NotNull
    public PsiDirectory[] getDirectories(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageBase.getDirectories must not be null");
        }
        ArrayList<PsiDirectory> result = null;
        Collection<PsiDirectory> directories = this.getAllDirectories();
        for (PsiDirectory directory : directories) {
            if (!scope.contains(directory.getVirtualFile())) continue;
            if (result == null) {
                result = new ArrayList<PsiDirectory>();
            }
            result.add(directory);
        }
        PsiDirectory[] psiDirectoryArray = result == null ? PsiDirectory.EMPTY_ARRAY : result.toArray(new PsiDirectory[result.size()]);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageBase.getDirectories must not return null");
        }
        return psiDirectoryArray;
    }

    @Override
    public RowIcon getElementIcon(int elementFlags) {
        return PsiPackageBase.createLayeredIcon(this, PlatformIcons.PACKAGE_ICON, elementFlags);
    }

    @Override
    public String getName() {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        if (this.myQualifiedName.isEmpty()) {
            return null;
        }
        int index = this.myQualifiedName.lastIndexOf(46);
        if (index < 0) {
            return this.myQualifiedName;
        }
        return this.myQualifiedName.substring(index + 1);
    }

    @Override
    @Nullable
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        PsiDirectory[] dirs;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageBase.setName must not be null");
        }
        this.checkSetName(name);
        for (PsiDirectory dir : dirs = this.getDirectories()) {
            dir.setName(name);
        }
        String nameAfterRename = PsiUtilCore.getQualifiedNameAfterRename(this.getQualifiedName(), name);
        return this.findPackage(nameAfterRename);
    }

    public void checkSetName(@NotNull String name) throws IncorrectOperationException {
        PsiDirectory[] dirs;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageBase.checkSetName must not be null");
        }
        for (PsiDirectory dir : dirs = this.getDirectories()) {
            dir.checkSetName(name);
        }
    }

    public PsiPackageBase getParentPackage() {
        if (this.myQualifiedName.isEmpty()) {
            return null;
        }
        int lastDot = this.myQualifiedName.lastIndexOf(46);
        if (lastDot < 0) {
            return this.createInstance(this.myManager, "");
        }
        return this.createInstance(this.myManager, this.myQualifiedName.substring(0, lastDot));
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        LOG.error("method not implemented");
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageBase.getChildren must not return null");
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public PsiElement getParent() {
        return this.getParentPackage();
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        return null;
    }

    @Override
    @Nullable
    public TextRange getTextRange() {
        return null;
    }

    @Override
    public int getStartOffsetInParent() {
        return -1;
    }

    @Override
    public int getTextLength() {
        return -1;
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return null;
    }

    @Override
    public int getTextOffset() {
        return -1;
    }

    @Override
    @Nullable
    public String getText() {
        return null;
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        if (ArrayUtil.EMPTY_CHAR_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiPackageBase.textToCharArray must not return null");
        }
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageBase.textMatches must not be null");
        }
        return false;
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageBase.textMatches must not be null");
        }
        return false;
    }

    @Override
    public PsiElement copy() {
        LOG.error("method not implemented");
        return null;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageBase.add must not be null");
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageBase.addBefore must not be null");
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageBase.addAfter must not be null");
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageBase.checkAdd must not be null");
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void delete() throws IncorrectOperationException {
        PsiDirectory[] dirs;
        this.checkDelete();
        for (PsiDirectory dir : dirs = this.getDirectories()) {
            dir.delete();
        }
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        for (PsiDirectory dir : this.getDirectories()) {
            dir.checkDelete();
        }
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageBase.replace must not be null");
        }
        throw new IncorrectOperationException();
    }

    @Override
    public boolean isWritable() {
        PsiDirectory[] dirs;
        for (PsiDirectory dir : dirs = this.getDirectories()) {
            if (dir.isWritable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageBase.accept must not be null");
        }
        visitor.visitElement(this);
    }

    @Override
    public String toString() {
        return "PsiPackageBase:" + this.getQualifiedName();
    }

    @Override
    public boolean canNavigate() {
        return this.isValid();
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    @Override
    public ASTNode getNode() {
        return null;
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiPackageBase.putInfo must not be null");
        }
        info.put("packageName", this.getName());
        info.put("packageQualifiedName", this.getQualifiedName());
    }
}

