/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import com.intellij.psi.impl.file.UpdateAddedFileProcessor;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiDirectoryImpl
extends PsiElementBase
implements Queryable,
PsiDirectory {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.file.PsiDirectoryImpl");
    private final PsiManagerImpl myManager;
    private final VirtualFile myFile;

    public PsiDirectoryImpl(PsiManagerImpl manager, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.<init> must not be null");
        }
        this.myManager = manager;
        this.myFile = file;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.getVirtualFile must not return null");
        }
        return virtualFile;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language = Language.ANY;
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.getLanguage must not return null");
        }
        return language;
    }

    @Override
    public PsiManager getManager() {
        return this.myManager;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myFile.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.getName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.setName must not be null");
        }
        this.checkSetName(name);
        try {
            this.myFile.rename(this.myManager, name);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString());
        }
        PsiDirectoryImpl psiDirectoryImpl = this;
        if (psiDirectoryImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.setName must not return null");
        }
        return psiDirectoryImpl;
    }

    @Override
    public void checkSetName(String name) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        VirtualFile parentFile = this.myFile.getParent();
        if (parentFile == null) {
            throw new IncorrectOperationException(VfsBundle.message("cannot.rename.root.directory", new Object[0]));
        }
        VirtualFile child = parentFile.findChild(name);
        if (child != null && !child.equals(this.myFile)) {
            throw new IncorrectOperationException(VfsBundle.message("file.already.exists.error", child.getPresentableUrl()));
        }
    }

    @Override
    public PsiDirectory getParentDirectory() {
        VirtualFile parentFile = this.myFile.getParent();
        if (parentFile == null) {
            return null;
        }
        return this.myManager.findDirectory(parentFile);
    }

    @Override
    @NotNull
    public PsiDirectory[] getSubdirectories() {
        VirtualFile[] files = this.myFile.getChildren();
        ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
        for (VirtualFile file : files) {
            PsiDirectory dir = this.myManager.findDirectory(file);
            if (dir == null) continue;
            dirs.add(dir);
        }
        PsiDirectory[] psiDirectoryArray = dirs.toArray(new PsiDirectory[dirs.size()]);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.getSubdirectories must not return null");
        }
        return psiDirectoryArray;
    }

    @Override
    @NotNull
    public PsiFile[] getFiles() {
        LOG.assertTrue(this.myFile.isValid());
        VirtualFile[] files = this.myFile.getChildren();
        ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
        for (VirtualFile file : files) {
            PsiFile psiFile = this.myManager.findFile(file);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        PsiFile[] psiFileArray = PsiUtilCore.toPsiFileArray(psiFiles);
        if (psiFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.getFiles must not return null");
        }
        return psiFileArray;
    }

    @Override
    public PsiDirectory findSubdirectory(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.findSubdirectory must not be null");
        }
        VirtualFile childVFile = this.myFile.findChild(name);
        if (childVFile == null) {
            return null;
        }
        return this.myManager.findDirectory(childVFile);
    }

    @Override
    public PsiFile findFile(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.findFile must not be null");
        }
        VirtualFile childVFile = this.myFile.findChild(name);
        if (childVFile == null) {
            return null;
        }
        return this.myManager.findFile(childVFile);
    }

    @Override
    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        this.checkValid();
        ProgressIndicatorProvider.checkCanceled();
        for (VirtualFile vFile : this.myFile.getChildren()) {
            PsiFile file;
            PsiDirectory dir;
            boolean isDir = vFile.isDirectory();
            if (processor instanceof PsiFileSystemItemProcessor && !((PsiFileSystemItemProcessor)processor).acceptItem(vFile.getName(), isDir) || !(isDir ? (dir = this.myManager.findDirectory(vFile)) != null && !processor.execute(dir) : (file = this.myManager.findFile(vFile)) != null && !processor.execute(file))) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        this.checkValid();
        VirtualFile[] files = this.myFile.getChildren();
        final ArrayList children = new ArrayList(files.length);
        this.processChildren(new PsiElementProcessor<PsiFileSystemItem>(){

            @Override
            public boolean execute(@NotNull PsiFileSystemItem element) {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl$1.execute must not be null");
                }
                children.add(element);
                return true;
            }
        });
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(children);
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.getChildren must not return null");
        }
        return psiElementArray;
    }

    private void checkValid() {
        if (!this.isValid()) {
            throw new PsiInvalidElementAccessException(this);
        }
    }

    @Override
    public PsiDirectory getParent() {
        return this.getParentDirectory();
    }

    @Override
    public PsiFile getContainingFile() {
        return null;
    }

    @Override
    public TextRange getTextRange() {
        return null;
    }

    @Override
    public int getStartOffsetInParent() {
        return -1;
    }

    @Override
    public int getTextLength() {
        return -1;
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return null;
    }

    @Override
    public int getTextOffset() {
        return -1;
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        if (ArrayUtil.EMPTY_CHAR_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.textToCharArray must not return null");
        }
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    @Override
    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.textMatches must not be null");
        }
        return false;
    }

    @Override
    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.textMatches must not be null");
        }
        return false;
    }

    @Override
    public final boolean isWritable() {
        return this.myFile.isWritable();
    }

    @Override
    public boolean isPhysical() {
        return !(this.myFile.getFileSystem() instanceof NonPhysicalFileSystem) && !this.myFile.getFileSystem().getProtocol().equals("temp");
    }

    @Override
    public PsiElement copy() {
        LOG.error("not implemented");
        return null;
    }

    @Override
    @NotNull
    public PsiDirectory createSubdirectory(@NotNull String name) throws IncorrectOperationException {
        PsiDirectory psiDirectory;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.createSubdirectory must not be null");
        }
        this.checkCreateSubdirectory(name);
        try {
            VirtualFile file = this.getVirtualFile().createChildDirectory(this.myManager, name);
            PsiDirectory directory = this.myManager.findDirectory(file);
            if (directory == null) {
                throw new IncorrectOperationException("Cannot find directory in '" + file.getPresentableUrl() + "'");
            }
            psiDirectory = directory;
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString());
        }
        if (psiDirectory == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.createSubdirectory must not return null");
        }
        return psiDirectory;
    }

    @Override
    public void checkCreateSubdirectory(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.checkCreateSubdirectory must not be null");
        }
        VirtualFile existingFile = this.getVirtualFile().findChild(name);
        if (existingFile != null) {
            throw new IncorrectOperationException(VfsBundle.message("file.already.exists.error", existingFile.getPresentableUrl()));
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    @NotNull
    public PsiFile createFile(@NotNull String name) throws IncorrectOperationException {
        PsiFile psiFile;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.createFile must not be null");
        }
        this.checkCreateFile(name);
        try {
            VirtualFile vFile = this.getVirtualFile().createChildData(this.myManager, name);
            psiFile = this.myManager.findFile(vFile);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString());
        }
        if (psiFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.createFile must not return null");
        }
        return psiFile;
    }

    @Override
    @NotNull
    public PsiFile copyFileFrom(@NotNull String newName, @NotNull PsiFile originalFile) throws IncorrectOperationException {
        PsiFile psiFile;
        if (newName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.copyFileFrom must not be null");
        }
        if (originalFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.copyFileFrom must not be null");
        }
        this.checkCreateFile(newName);
        Document document = PsiDocumentManager.getInstance(this.getProject()).getDocument(originalFile);
        if (document != null) {
            FileDocumentManager.getInstance().saveDocument(document);
        }
        VirtualFile parent = this.getVirtualFile();
        try {
            VirtualFile copyVFile;
            VirtualFile vFile = originalFile.getVirtualFile();
            if (vFile == null) {
                throw new IncorrectOperationException("Cannot copy nonphysical file");
            }
            if (parent.getFileSystem() == vFile.getFileSystem()) {
                copyVFile = vFile.copy(this, parent, newName);
            } else if (vFile instanceof LightVirtualFile) {
                copyVFile = parent.createChildData(this, newName);
                copyVFile.setBinaryContent(originalFile.getText().getBytes(copyVFile.getCharset()));
            } else {
                copyVFile = VfsUtilCore.copyFile(this, vFile, parent, newName);
            }
            LOG.assertTrue(copyVFile != null, "File was not copied: " + vFile);
            PsiFile copyPsi = this.myManager.findFile(copyVFile);
            if (copyPsi == null) {
                LOG.error("Could not find file '" + copyVFile + "' after copying '" + vFile + "'");
            }
            PsiDirectoryImpl.updateAddedFile(copyPsi);
            psiFile = copyPsi;
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString(), e);
        }
        if (psiFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.copyFileFrom must not return null");
        }
        return psiFile;
    }

    private static void updateAddedFile(PsiFile copyPsi) throws IncorrectOperationException {
        UpdateAddedFileProcessor processor = UpdateAddedFileProcessor.forElement(copyPsi);
        if (processor != null) {
            TreeElement tree = (TreeElement)SourceTreeToPsiMap.psiElementToTree(copyPsi);
            if (tree != null) {
                ChangeUtil.encodeInformation(tree);
            }
            processor.update(copyPsi, null);
            if (tree != null) {
                ChangeUtil.decodeInformation(tree);
            }
        }
    }

    @Override
    public void checkCreateFile(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.checkCreateFile must not be null");
        }
        VirtualFile existingFile = this.getVirtualFile().findChild(name);
        if (existingFile != null) {
            throw new IncorrectOperationException(VfsBundle.message("file.already.exists.error", existingFile.getPresentableUrl()));
        }
        CheckUtil.checkWritable(this);
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.add must not be null");
        }
        this.checkAdd(element);
        if (element instanceof PsiDirectory) {
            LOG.error("not implemented");
            return null;
        }
        if (element instanceof PsiFile) {
            PsiFile originalFile = (PsiFile)element;
            try {
                VirtualFile newVFile;
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(this.myManager.getProject());
                if (originalFile instanceof PsiFileImpl) {
                    newVFile = this.myFile.createChildData(this.myManager, originalFile.getName());
                    String text = originalFile.getText();
                    PsiFile psiFile = this.getManager().findFile(newVFile);
                    Document document = psiFile == null ? null : psiDocumentManager.getDocument(psiFile);
                    FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                    if (document != null) {
                        document.setText(text);
                        fileDocumentManager.saveDocument(document);
                    } else {
                        String lineSeparator = fileDocumentManager.getLineSeparator(newVFile, this.getProject());
                        if (!lineSeparator.equals("\n")) {
                            text = StringUtil.convertLineSeparators(text, lineSeparator);
                        }
                        LoadTextUtil.write(this.getProject(), newVFile, this.myManager, text, -1L);
                    }
                } else {
                    byte[] storedContents = ((PsiBinaryFileImpl)originalFile).getStoredContents();
                    if (storedContents != null) {
                        newVFile = this.myFile.createChildData(this.myManager, originalFile.getName());
                        newVFile.setBinaryContent(storedContents);
                    } else {
                        newVFile = VfsUtilCore.copyFile(null, originalFile.getVirtualFile(), this.myFile);
                    }
                }
                psiDocumentManager.commitAllDocuments();
                PsiFile newFile = this.myManager.findFile(newVFile);
                PsiDirectoryImpl.updateAddedFile(newFile);
                return newFile;
            }
            catch (IOException e) {
                throw new IncorrectOperationException(e.toString(), e);
            }
        }
        LOG.assertTrue(false);
        return null;
    }

    @Override
    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.checkAdd must not be null");
        }
        CheckUtil.checkWritable(this);
        if (element instanceof PsiDirectory) {
            PsiDirectory[] subpackages;
            String name = ((PsiDirectory)element).getName();
            for (PsiDirectory dir : subpackages = this.getSubdirectories()) {
                if (!Comparing.strEqual(dir.getName(), name)) continue;
                throw new IncorrectOperationException(VfsBundle.message("dir.already.exists.error", dir.getVirtualFile().getPresentableUrl()));
            }
        } else if (element instanceof PsiFile) {
            PsiFile[] files;
            String name = ((PsiFile)element).getName();
            for (PsiFile file : files = this.getFiles()) {
                if (!Comparing.strEqual(file.getName(), name, SystemInfo.isFileSystemCaseSensitive)) continue;
                throw new IncorrectOperationException(VfsBundle.message("file.already.exists.error", file.getVirtualFile().getPresentableUrl()));
            }
        } else {
            throw new IncorrectOperationException();
        }
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.addBefore must not be null");
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.addAfter must not be null");
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        try {
            this.myFile.delete(this.myManager);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString(), e);
        }
    }

    @Override
    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkDelete(this.myFile);
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.replace must not be null");
        }
        LOG.error("not implemented");
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.accept must not be null");
        }
        visitor.visitDirectory(this);
    }

    @Override
    public String toString() {
        return "PsiDirectory:" + this.myFile.getPresentableUrl();
    }

    @Override
    public ASTNode getNode() {
        return null;
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiNavigationSupport.getInstance().navigateToDirectory(this, requestFocus);
    }

    @Override
    protected Icon getElementIcon(int flags) {
        return PlatformIcons.DIRECTORY_CLOSED_ICON;
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.putInfo must not be null");
        }
        info.put("fileName", this.getName());
    }
}

