/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsDocCommentImpl;
import com.intellij.psi.impl.compiled.ClsIdentifierImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class ClsMemberImpl<T extends NamedStub>
extends ClsRepositoryPsiElement<T>
implements PsiDocCommentOwner,
PsiNameIdentifierOwner {
    private PsiDocComment myDocComment;
    private PsiIdentifier myNameIdentifier;

    protected ClsMemberImpl(T stub) {
        super(stub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PsiDocComment getDocComment() {
        if (!this.isDeprecated()) {
            return null;
        }
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (this.myDocComment == null) {
                this.myDocComment = new ClsDocCommentImpl(this);
            }
            return this.myDocComment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public PsiIdentifier getNameIdentifier() {
        Object object = LAZY_BUILT_LOCK;
        // MONITORENTER : object
        if (this.myNameIdentifier == null) {
            this.myNameIdentifier = new ClsIdentifierImpl(this, this.getName());
        }
        PsiIdentifier psiIdentifier = this.myNameIdentifier;
        // MONITOREXIT : object
        if (psiIdentifier != null) return psiIdentifier;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMemberImpl.getNameIdentifier must not return null");
    }

    @Override
    @NotNull
    public String getName() {
        String string = ((NamedStub)this.getStub()).getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMemberImpl.getName must not return null");
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMemberImpl.setName must not be null");
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name);
        return this;
    }
}

