/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsJavaCodeReferenceElementImpl
extends ClsElementImpl
implements PsiJavaCodeReferenceElement {
    private static final ClsTypeElementImpl[] EMPTY_ARRAY = new ClsTypeElementImpl[0];
    private final PsiElement myParent;
    private final String myCanonicalText;
    private final String myQualifiedName;
    private final ClsTypeElementImpl[] myTypeParameters;
    private volatile PsiType[] myTypeParametersCachedTypes = null;

    public ClsJavaCodeReferenceElementImpl(PsiElement parent, String canonicalText) {
        this.myParent = parent;
        this.myCanonicalText = canonicalText;
        String[] classParametersText = PsiNameHelper.getClassParametersText(canonicalText);
        int length = classParametersText.length;
        this.myTypeParameters = length == 0 ? EMPTY_ARRAY : new ClsTypeElementImpl[length];
        for (int i = 0; i < length; ++i) {
            String s = classParametersText[length - i - 1];
            char variance = '\u0000';
            if (s.startsWith("?extends")) {
                variance = '+';
                s = s.substring("?extends".length());
            } else if (s.startsWith("?super")) {
                variance = '-';
                s = s.substring("?super".length());
            } else if (StringUtil.startsWithChar(s, '?')) {
                variance = '*';
                s = s.substring(1);
            }
            this.myTypeParameters[i] = new ClsTypeElementImpl(this, s, variance);
        }
        this.myQualifiedName = PsiNameHelper.getQualifiedClassName(this.myCanonicalText, false);
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.getChildren must not return null");
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public String getText() {
        return PsiNameHelper.getPresentableText(this);
    }

    @Override
    public int getTextLength() {
        return this.getText().length();
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.myCanonicalText;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.getCanonicalText must not return null");
        }
        return string;
    }

    private JavaResolveResult advancedResolveImpl() {
        PsiElement resolve = this.resolveElement();
        if (resolve instanceof PsiClass) {
            HashMap<PsiTypeParameter, PsiType> substitutionMap = new HashMap<PsiTypeParameter, PsiType>();
            int index = 0;
            for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiClass)resolve)) {
                if (index >= this.myTypeParameters.length) {
                    PsiTypeParameterListOwner parameterOwner = parameter.getOwner();
                    if (parameterOwner == resolve) {
                        substitutionMap.put(parameter, null);
                    } else if (parameterOwner instanceof PsiClass) {
                        PsiElement containingClass = this.myParent;
                        while ((containingClass = PsiTreeUtil.getParentOfType(containingClass, PsiClass.class, true)) != null) {
                            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)parameterOwner, (PsiClass)containingClass, PsiSubstitutor.EMPTY);
                            if (superClassSubstitutor == null) continue;
                            substitutionMap.put(parameter, superClassSubstitutor.substitute(parameter));
                            break;
                        }
                    }
                } else {
                    substitutionMap.put(parameter, this.myTypeParameters[index].getType());
                }
                ++index;
            }
            return new CandidateInfo(resolve, PsiSubstitutorImpl.createSubstitutor(substitutionMap));
        }
        return new CandidateInfo(resolve, PsiSubstitutor.EMPTY);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult javaResolveResult;
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        if (results.length == 1) {
            javaResolveResult = results[0];
            if (javaResolveResult == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.advancedResolve must not return null");
            return javaResolveResult;
        }
        javaResolveResult = JavaResolveResult.EMPTY;
        if (javaResolveResult != null) return javaResolveResult;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.advancedResolve must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray;
        PsiFile file = this.getContainingFile();
        ResolveCache resolveCache = ResolveCache.getInstance(file.getProject());
        ResolveResult[] results = resolveCache.resolveWithCaching(this, Resolver.INSTANCE, true, incompleteCode, file);
        if (results.length == 0) {
            javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
            if (JavaResolveResult.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.multiResolve must not return null");
            return javaResolveResultArray;
        }
        javaResolveResultArray = (JavaResolveResult[])results;
        if (javaResolveResultArray != null) return javaResolveResultArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.multiResolve must not return null");
    }

    @Override
    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Nullable
    private PsiElement resolveElement() {
        PsiElement element;
        for (element = this.getParent(); element != null && (!(element instanceof PsiClass) || element instanceof PsiTypeParameter); element = element.getParent()) {
            PsiMethod method;
            PsiTypeParameterList list;
            if (!(element instanceof PsiMethod) || (list = (method = (PsiMethod)element).getTypeParameterList()) == null) continue;
            PsiTypeParameter[] parameters = list.getTypeParameters();
            for (int i = 0; parameters != null && i < parameters.length; ++i) {
                PsiTypeParameter parameter = parameters[i];
                if (!this.myQualifiedName.equals(parameter.getName())) continue;
                return parameter;
            }
        }
        if (element == null) {
            return null;
        }
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)element)) {
            if (!this.myQualifiedName.equals(parameter.getName())) continue;
            return parameter;
        }
        return this.resolveClassPreferringMyJar();
    }

    @Nullable
    private PsiClass resolveClassPreferringMyJar() {
        VirtualFile jarFile;
        PsiClass[] classes = JavaPsiFacade.getInstance(this.getProject()).findClasses(this.myQualifiedName, this.getResolveScope());
        if (classes.length == 0) {
            return null;
        }
        if (classes.length > 1 && (jarFile = PsiUtil.getJarFile(this)) != null) {
            for (PsiClass aClass : classes) {
                if (!Comparing.equal(PsiUtil.getJarFile(aClass), jarFile)) continue;
                return aClass;
            }
        }
        return classes[0];
    }

    @Override
    public void processVariants(PsiScopeProcessor processor) {
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return null;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        return null;
    }

    @Override
    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    @Override
    public String getReferenceName() {
        return PsiNameHelper.getShortClassName(this.myCanonicalText);
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.bindToElement must not be null");
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass = (PsiClass)element;
        return this.myCanonicalText.equals(aClass.getQualifiedName()) || this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for references to compiled code");
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.appendMirrorText must not be null");
        }
        buffer.append(this.getCanonicalText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, JavaElementType.JAVA_CODE_REFERENCE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiJavaCodeReferenceElement:" + this.getText();
    }

    @Override
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public PsiElement getElement() {
        return this;
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        PsiType[] cachedTypes = this.myTypeParametersCachedTypes;
        if (cachedTypes == null) {
            cachedTypes = this.myTypeParameters.length == 0 ? PsiType.EMPTY_ARRAY : new PsiType[this.myTypeParameters.length];
            for (int i = 0; i < cachedTypes.length; ++i) {
                cachedTypes[cachedTypes.length - i - 1] = this.myTypeParameters[i].getType();
            }
            this.myTypeParametersCachedTypes = cachedTypes;
        }
        if (cachedTypes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl.getTypeParameters must not return null");
        }
        return cachedTypes;
    }

    @Override
    public boolean isQualified() {
        return false;
    }

    @Override
    public PsiElement getQualifier() {
        return null;
    }

    private static class Resolver
    implements ResolveCache.PolyVariantResolver<ClsJavaCodeReferenceElementImpl> {
        public static final Resolver INSTANCE = new Resolver();

        private Resolver() {
        }

        @Override
        @NotNull
        public JavaResolveResult[] resolve(@NotNull ClsJavaCodeReferenceElementImpl ref, boolean incompleteCode) {
            JavaResolveResult[] javaResolveResultArray;
            if (ref == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl$Resolver.resolve must not be null");
            }
            JavaResolveResult resolveResult = ref.advancedResolveImpl();
            if (resolveResult.getElement() == null) {
                javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
            } else {
                JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                javaResolveResultArray = javaResolveResultArray2;
                javaResolveResultArray2[0] = resolveResult;
            }
            if (javaResolveResultArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsJavaCodeReferenceElementImpl$Resolver.resolve must not return null");
            }
            return javaResolveResultArray;
        }
    }
}

