/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.compiled.ClsStubBuilderFactory;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.cls.ClsFormatException;

public class ClassFileStubBuilder
implements BinaryFileStubBuilder {
    @Override
    public boolean acceptsFile(VirtualFile file) {
        return true;
    }

    @Override
    public StubElement buildStubTree(VirtualFile file, byte[] content, Project project) {
        try {
            ClsStubBuilderFactory[] factories;
            for (ClsStubBuilderFactory factory : factories = Extensions.getExtensions(ClsStubBuilderFactory.EP_NAME)) {
                PsiFileStub stub;
                if (factory.isInnerClass(file) || !factory.canBeProcessed(file, content) || (stub = factory.buildFileStub(file, content, project)) == null) continue;
                return stub;
            }
            return null;
        }
        catch (ClsFormatException e) {
            return null;
        }
    }

    @Override
    public int getStubVersion() {
        return 22;
    }
}

