/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiInvalidElementAccessException
extends RuntimeException {
    private final SoftReference<PsiElement> myElementReference;

    public PsiInvalidElementAccessException(PsiElement element) {
        this(element, (String)null);
    }

    public PsiInvalidElementAccessException(PsiElement element, @Nullable String message) {
        this(element, PsiInvalidElementAccessException.getMessageWithReason(element, message), null);
    }

    public PsiInvalidElementAccessException(PsiElement element, @Nullable Throwable cause) {
        this(element, PsiInvalidElementAccessException.getMessageWithReason(element, null), cause);
    }

    public PsiInvalidElementAccessException(PsiElement element, @Nullable String message, @Nullable Throwable cause) {
        super(message, cause);
        this.myElementReference = new SoftReference<PsiElement>(element);
    }

    private static String getMessageWithReason(@Nullable PsiElement element, @Nullable String message) {
        return (element == null ? "Unknown psi element" : "Element: " + element.getClass() + " because: " + PsiInvalidElementAccessException.reason(element)) + (message == null ? "" : "; " + message);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNls
    @NotNull
    private static String reason(@NotNull PsiElement root) {
        String string;
        PsiElement element;
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiInvalidElementAccessException.reason must not be null");
        }
        if (root == PsiUtilCore.NULL_PSI_ELEMENT) {
            return "NULL_PSI_ELEMENT";
        }
        PsiElement psiElement = element = root instanceof PsiFile ? root : root.getParent();
        if (element == null) {
            return "parent is null";
        }
        while (element != null && !(element instanceof PsiFile) && element.getParent() != null) {
            element = element.getParent();
        }
        if (!(element instanceof PsiFile)) return "containing file is null";
        PsiFile psiFile = (PsiFile)element;
        PsiFile file = psiFile;
        if (file == null) {
            return "containing file is null";
        }
        FileViewProvider provider = file.getViewProvider();
        VirtualFile vFile = provider.getVirtualFile();
        if (!vFile.isValid()) {
            String string2 = vFile + " is invalid";
            string = string2;
            if (string2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/PsiInvalidElementAccessException.reason must not return null");
            return string;
        }
        if (!provider.isPhysical()) {
            return "non-physical provider";
        }
        PsiManager manager = file.getManager();
        if (manager.getProject().isDisposed()) {
            return "project is disposed";
        }
        Language language = file.getLanguage();
        if (language != provider.getBaseLanguage()) {
            String string3 = "File language:" + language + " != Provider base language:" + provider.getBaseLanguage();
            string = string3;
            if (string3 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/PsiInvalidElementAccessException.reason must not return null");
            return string;
        }
        FileViewProvider provider1 = manager.findViewProvider(vFile);
        if (provider == provider1) return "psi is outdated";
        String string4 = "different providers: " + provider + "(" + Integer.toHexString(System.identityHashCode(provider)) + "); " + provider1 + "(" + Integer.toHexString(System.identityHashCode(provider1)) + ")";
        string = string4;
        if (string4 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/PsiInvalidElementAccessException.reason must not return null");
        return string;
    }

    @Nullable
    public PsiElement getPsiElement() {
        return this.myElementReference.get();
    }
}

