/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementResolveResult
implements ResolveResult {
    @NotNull
    private final PsiElement myElement;
    private final boolean myValidResult;

    public PsiElementResolveResult(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiElementResolveResult.<init> must not be null");
        }
        this(element, true);
    }

    public PsiElementResolveResult(@NotNull PsiElement element, boolean validResult) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiElementResolveResult.<init> must not be null");
        }
        this.myElement = element;
        this.myValidResult = validResult;
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiElementResolveResult.getElement must not return null");
        }
        return psiElement;
    }

    @Override
    public boolean isValidResult() {
        return this.myValidResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiElementResolveResult that = (PsiElementResolveResult)o;
        return this.myElement.equals(that.myElement);
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }

    @NonNls
    public String toString() {
        return "PsiElementResolveResult with " + this.myElement.getClass() + ": " + (this.myElement instanceof PsiNamedElement ? ((PsiNamedElement)this.myElement).getName() : this.myElement.getText());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static ResolveResult[] createResults(@Nullable Collection<? extends PsiElement> elements) {
        ResolveResult[] resolveResultArray;
        if (elements == null || elements.isEmpty()) {
            resolveResultArray = EMPTY_ARRAY;
            if (EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/PsiElementResolveResult.createResults must not return null");
            return resolveResultArray;
        }
        ResolveResult[] results = new ResolveResult[elements.size()];
        int i = 0;
        for (PsiElement psiElement : elements) {
            results[i++] = new PsiElementResolveResult(psiElement);
        }
        resolveResultArray = results;
        if (results != null) return resolveResultArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/PsiElementResolveResult.createResults must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static ResolveResult[] createResults(@Nullable PsiElement[] elements) {
        ResolveResult[] resolveResultArray;
        if (elements == null || elements.length == 0) {
            resolveResultArray = EMPTY_ARRAY;
            if (EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/PsiElementResolveResult.createResults must not return null");
            return resolveResultArray;
        }
        ResolveResult[] results = new ResolveResult[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            results[i] = new PsiElementResolveResult(elements[i]);
        }
        resolveResultArray = results;
        if (results != null) return resolveResultArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/PsiElementResolveResult.createResults must not return null");
    }
}

