/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.annotations.NotNull;

public abstract class LiteralTextEscaper<T extends PsiLanguageInjectionHost> {
    protected final T myHost;

    protected LiteralTextEscaper(@NotNull T host) {
        if (host == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/LiteralTextEscaper.<init> must not be null");
        }
        this.myHost = host;
    }

    public abstract boolean decode(@NotNull TextRange var1, @NotNull StringBuilder var2);

    public abstract int getOffsetInHost(int var1, @NotNull TextRange var2);

    @NotNull
    public TextRange getRelevantTextRange() {
        TextRange textRange = TextRange.from(0, this.myHost.getTextLength());
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/LiteralTextEscaper.getRelevantTextRange must not return null");
        }
        return textRange;
    }

    public abstract boolean isOneLine();

    public static <T extends PsiLanguageInjectionHost> LiteralTextEscaper<T> createSimple(T element) {
        return new LiteralTextEscaper<T>(element){

            @Override
            public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
                if (rangeInsideHost == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/LiteralTextEscaper$1.decode must not be null");
                }
                if (outChars == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/LiteralTextEscaper$1.decode must not be null");
                }
                outChars.append(rangeInsideHost.substring(this.myHost.getText()));
                return true;
            }

            @Override
            public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
                if (rangeInsideHost == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/LiteralTextEscaper$1.getOffsetInHost must not be null");
                }
                return rangeInsideHost.getStartOffset() + offsetInDecoded;
            }

            @Override
            public boolean isOneLine() {
                return true;
            }
        };
    }
}

