/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyedExtensionCollector<T, KeyT> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.KeyedExtensionCollector");
    private final Map<String, List<T>> myExplicitExtensions = new THashMap<String, List<T>>();
    private final ConcurrentMap<String, List<T>> myCache = new ConcurrentHashMap<String, List<T>>();
    @NonNls
    private final String lock;
    private ExtensionPoint<KeyedLazyInstance<T>> myPoint;
    private final String myEpName;
    private ExtensionPointAndAreaListener<KeyedLazyInstance<T>> myListener;
    private final List<ExtensionPointListener<T>> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public KeyedExtensionCollector(@NonNls String epName) {
        this.myEpName = epName;
        this.lock = new String("lock for KeyedExtensionCollector " + epName);
        this.resetAreaListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAreaListener() {
        String string = this.lock;
        synchronized (string) {
            this.myCache.clear();
            if (this.myPoint != null) {
                this.myPoint.removeExtensionPointListener(this.myListener);
                this.myPoint = null;
                this.myListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitExtension(KeyT key, T t) {
        String string = this.lock;
        synchronized (string) {
            String skey = this.keyToString(key);
            List<T> list = this.myExplicitExtensions.get(skey);
            if (list == null) {
                list = new ArrayList<T>();
                this.myExplicitExtensions.put(skey, list);
            }
            list.add(t);
            this.myCache.remove(skey);
            for (ExtensionPointListener<T> listener : this.myListeners) {
                listener.extensionAdded(t, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExplicitExtension(KeyT key, T t) {
        String string = this.lock;
        synchronized (string) {
            String skey = this.keyToString(key);
            List<T> list = this.myExplicitExtensions.get(skey);
            if (list != null) {
                list.remove(t);
                this.myCache.remove(skey);
            }
            for (ExtensionPointListener<T> listener : this.myListeners) {
                listener.extensionRemoved(t, null);
            }
        }
    }

    protected String keyToString(KeyT key) {
        return key.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<T> forKey(KeyT key) {
        List<T> list;
        String stringKey = this.keyToString(key);
        List<T> cache = (List<T>)this.myCache.get(stringKey);
        if (cache != null) {
            list = cache;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/KeyedExtensionCollector.forKey must not return null");
            return list;
        }
        cache = this.buildExtensions(stringKey, key);
        list = cache = ConcurrencyUtil.cacheOrGet(this.myCache, stringKey, cache);
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/KeyedExtensionCollector.forKey must not return null");
    }

    public T findSingle(KeyT key) {
        List<T> list = this.forKey(key);
        return list.isEmpty() ? null : (T)list.get(0);
    }

    protected List<T> buildExtensions(String stringKey, KeyT key) {
        return this.buildExtensions(Collections.singleton(stringKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List<T> buildExtensions(Set<String> keys) {
        String string = this.lock;
        synchronized (string) {
            ArrayList<T> result = null;
            for (Map.Entry<String, List<T>> entry : this.myExplicitExtensions.entrySet()) {
                String key = entry.getKey();
                if (!keys.contains(key)) continue;
                if (result == null) {
                    result = new ArrayList<T>();
                }
                List<T> list = entry.getValue();
                result.addAll(list);
            }
            ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
            if (point != null) {
                KeyedLazyInstance<T>[] beans;
                for (KeyedLazyInstance<T> bean : beans = point.getExtensions()) {
                    T instance;
                    if (!keys.contains(bean.getKey())) continue;
                    try {
                        instance = bean.getInstance();
                    }
                    catch (Exception e) {
                        LOG.error(e);
                        continue;
                    }
                    catch (NoClassDefFoundError e) {
                        LOG.error(e);
                        continue;
                    }
                    catch (UnsupportedClassVersionError e) {
                        LOG.error(e);
                        continue;
                    }
                    if (result == null) {
                        result = new ArrayList();
                    }
                    result.add(instance);
                }
            }
            return result == null ? Collections.emptyList() : result;
        }
    }

    @Nullable
    private ExtensionPoint<KeyedLazyInstance<T>> getPoint() {
        if (this.myPoint == null && Extensions.getRootArea().hasExtensionPoint(this.myEpName)) {
            ExtensionPointName typesafe = ExtensionPointName.create(this.myEpName);
            this.myPoint = Extensions.getRootArea().getExtensionPoint(typesafe);
            this.myListener = new ExtensionPointAndAreaListener<KeyedLazyInstance<T>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void extensionAdded(@NotNull KeyedLazyInstance<T> bean, @Nullable PluginDescriptor pluginDescriptor) {
                    if (bean == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/KeyedExtensionCollector$1.extensionAdded must not be null");
                    }
                    String string = KeyedExtensionCollector.this.lock;
                    synchronized (string) {
                        if (bean.getKey() == null) {
                            if (pluginDescriptor != null) {
                                throw new PluginException("No key specified for extension of class " + bean.getInstance().getClass(), pluginDescriptor.getPluginId());
                            }
                            LOG.error("No key specified for extension of class " + bean.getInstance().getClass());
                            return;
                        }
                        KeyedExtensionCollector.this.myCache.remove(bean.getKey());
                        for (ExtensionPointListener listener : KeyedExtensionCollector.this.myListeners) {
                            listener.extensionAdded(bean.getInstance(), null);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void extensionRemoved(@NotNull KeyedLazyInstance<T> bean, @Nullable PluginDescriptor pluginDescriptor) {
                    if (bean == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/KeyedExtensionCollector$1.extensionRemoved must not be null");
                    }
                    String string = KeyedExtensionCollector.this.lock;
                    synchronized (string) {
                        KeyedExtensionCollector.this.myCache.remove(bean.getKey());
                        for (ExtensionPointListener listener : KeyedExtensionCollector.this.myListeners) {
                            listener.extensionRemoved(bean.getInstance(), null);
                        }
                    }
                }

                @Override
                public void areaReplaced(ExtensionsArea area) {
                    KeyedExtensionCollector.this.resetAreaListener();
                }
            };
            this.myPoint.addExtensionPointListener(this.myListener);
        }
        return this.myPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyExtensions() {
        String string = this.lock;
        synchronized (string) {
            if (!this.myExplicitExtensions.isEmpty()) {
                return true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            ExtensionPoint<KeyedLazyInstance<T>> point = this.getPoint();
            return point != null && point.hasAnyExtensions();
        }
    }

    public void addListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/KeyedExtensionCollector.addListener must not be null");
        }
        this.myListeners.add(listener);
    }

    public void removeListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/KeyedExtensionCollector.removeListener must not be null");
        }
        this.myListeners.remove(listener);
    }
}

