/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import org.jetbrains.annotations.NotNull;

public class ApplicationManager {
    protected static Application ourApplication = null;

    public static Application getApplication() {
        return ourApplication;
    }

    private static void setApplication(@NotNull Application instance) {
        if (instance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/application/ApplicationManager.setApplication must not be null");
        }
        ourApplication = instance;
        CachedSingletonsRegistry.cleanupCachedFields();
    }

    public static void setApplication(@NotNull Application instance, @NotNull Getter<FileTypeRegistry> fileTypeRegistryGetter, @NotNull Getter<EncodingRegistry> encodingRegistryGetter, @NotNull Disposable parent) {
        if (instance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/application/ApplicationManager.setApplication must not be null");
        }
        if (fileTypeRegistryGetter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/application/ApplicationManager.setApplication must not be null");
        }
        if (encodingRegistryGetter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/application/ApplicationManager.setApplication must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/application/ApplicationManager.setApplication must not be null");
        }
        final Application old = ourApplication;
        final Getter<FileTypeRegistry> oldFileTypeRegistry = FileTypeRegistry.ourInstanceGetter;
        final Getter<EncodingRegistry> oldEncodingRegistry = EncodingRegistry.ourInstanceGetter;
        Disposer.register(parent, new Disposable(){

            @Override
            public void dispose() {
                if (old != null) {
                    ApplicationManager.setApplication(old);
                    FileTypeRegistry.ourInstanceGetter = oldFileTypeRegistry;
                    EncodingRegistry.ourInstanceGetter = oldEncodingRegistry;
                }
            }
        });
        ApplicationManager.setApplication(instance);
        FileTypeRegistry.ourInstanceGetter = fileTypeRegistryGetter;
        EncodingRegistry.ourInstanceGetter = encodingRegistryGetter;
    }
}

