/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBuilderFactoryImpl
extends PsiBuilderFactory {
    @Override
    @NotNull
    public PsiBuilder createBuilder(@NotNull Project project, @NotNull ASTNode chameleon) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderFactoryImpl.createBuilder must not be null");
        }
        if (chameleon == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderFactoryImpl.createBuilder must not be null");
        }
        PsiBuilder psiBuilder = this.createBuilder(project, chameleon, null, chameleon.getElementType().getLanguage(), chameleon.getChars());
        if (psiBuilder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/impl/PsiBuilderFactoryImpl.createBuilder must not return null");
        }
        return psiBuilder;
    }

    @Override
    @NotNull
    public PsiBuilder createBuilder(@NotNull Project project, @NotNull ASTNode chameleon, @Nullable Lexer lexer, @NotNull Language lang, @NotNull CharSequence seq) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderFactoryImpl.createBuilder must not be null");
        }
        if (chameleon == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderFactoryImpl.createBuilder must not be null");
        }
        if (lang == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderFactoryImpl.createBuilder must not be null");
        }
        if (seq == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderFactoryImpl.createBuilder must not be null");
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        PsiBuilderImpl psiBuilderImpl = new PsiBuilderImpl(project, parserDefinition, lexer != null ? lexer : PsiBuilderFactoryImpl.createLexer(project, lang), chameleon, seq);
        if (psiBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/impl/PsiBuilderFactoryImpl.createBuilder must not return null");
        }
        return psiBuilderImpl;
    }

    @Override
    @NotNull
    public PsiBuilder createBuilder(@NotNull Project project, @NotNull LighterLazyParseableNode chameleon, @Nullable Lexer lexer, @NotNull Language lang, @NotNull CharSequence seq) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderFactoryImpl.createBuilder must not be null");
        }
        if (chameleon == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderFactoryImpl.createBuilder must not be null");
        }
        if (lang == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderFactoryImpl.createBuilder must not be null");
        }
        if (seq == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/lang/impl/PsiBuilderFactoryImpl.createBuilder must not be null");
        }
        Language language = chameleon.getTokenType().getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        PsiBuilderImpl psiBuilderImpl = new PsiBuilderImpl(project, parserDefinition, lexer != null ? lexer : PsiBuilderFactoryImpl.createLexer(project, lang), chameleon, seq);
        if (psiBuilderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/impl/PsiBuilderFactoryImpl.createBuilder must not return null");
        }
        return psiBuilderImpl;
    }

    private static Lexer createLexer(Project project, Language lang) {
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        assert (parserDefinition != null) : "ParserDefinition absent for language: " + lang.getID();
        return parserDefinition.createLexer(project);
    }
}

